/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.media.drawing.Shape;
import org.apache.pivot.wtk.media.drawing.TextListener;

public class Text
extends Shape {
    private String text = null;
    private Font font = DEFAULT_FONT;
    private int width = -1;
    private HorizontalAlignment alignment = HorizontalAlignment.CENTER;
    private ArrayList<GlyphVector> glyphVectors = null;
    private TextListenerList textListeners = new TextListenerList();
    public static final Font DEFAULT_FONT = new Font("Verdana", 0, 11);
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    public Text() {
        this.setFill(Color.BLACK);
        this.setStrokeThickness(0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        if (string2 != string) {
            this.text = string;
            this.invalidate();
            this.textListeners.textChanged(this, string2);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        Font font2 = this.font;
        if (font2 != font) {
            this.font = font;
            this.invalidate();
            this.textListeners.fontChanged(this, font2);
        }
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Font.decode(string));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.width;
        if (n2 != n) {
            this.width = n;
            this.invalidate();
            this.textListeners.widthChanged(this, n2);
        }
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException();
        }
        HorizontalAlignment horizontalAlignment2 = this.alignment;
        if (horizontalAlignment2 != horizontalAlignment) {
            this.alignment = horizontalAlignment;
            this.update();
            this.textListeners.alignmentChanged(this, horizontalAlignment2);
        }
    }

    public final void setAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.setAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    @Override
    public boolean contains(int n, int n2) {
        Bounds bounds = this.getBounds();
        return n >= 0 && n < bounds.width && n2 >= 0 && n2 < bounds.height;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.getWidth();
        if (this.glyphVectors.getLength() > 0) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (FONT_RENDER_CONTEXT.isAntiAliased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
            }
            if (FONT_RENDER_CONTEXT.usesFractionalMetrics()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            Paint paint = this.getFill();
            Paint paint2 = this.getStroke();
            int n2 = this.getStrokeThickness();
            LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            float f = lineMetrics.getAscent();
            float f2 = 0.0f;
            int n3 = this.glyphVectors.getLength();
            for (int i = 0; i < n3; ++i) {
                GlyphVector glyphVector = (GlyphVector)this.glyphVectors.get(i);
                Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                float f3 = (float)rectangle2D.getWidth();
                float f4 = 0.0f;
                switch (this.alignment) {
                    case LEFT: {
                        f4 = 0.0f;
                        break;
                    }
                    case RIGHT: {
                        f4 = (float)n - f3;
                        break;
                    }
                    case CENTER: {
                        f4 = ((float)n - f3) / 2.0f;
                    }
                }
                if (paint != null) {
                    graphics2D.setFont(this.font);
                    graphics2D.setPaint(paint);
                    graphics2D.drawGlyphVector(glyphVector, f4, f2 + f);
                }
                if (paint2 != null && n2 > 0) {
                    java.awt.Shape shape = glyphVector.getOutline();
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(new BasicStroke(n2));
                    graphics2D.translate(f4, f2 + f);
                    graphics2D.draw(shape);
                    graphics2D.translate(-f4, -(f2 + f));
                }
                f2 = (float)((double)f2 + rectangle2D.getHeight());
            }
        }
    }

    @Override
    protected void validate() {
        if (!this.isValid()) {
            int n;
            int n2;
            this.glyphVectors = new ArrayList();
            if (this.width == -1) {
                if (this.text == null || this.text.length() == 0) {
                    n2 = 0;
                    n = 0;
                } else {
                    GlyphVector glyphVector = this.font.createGlyphVector(FONT_RENDER_CONTEXT, this.text);
                    this.glyphVectors.add((Object)glyphVector);
                    Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                    n2 = (int)Math.ceil(rectangle2D.getWidth());
                    n = (int)Math.ceil(rectangle2D.getHeight());
                }
            } else {
                float f = 0.0f;
                float f2 = 0.0f;
                int n3 = this.text.length();
                if (n3 > 0) {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    int n4;
                    float f3 = 0.0f;
                    int n5 = -1;
                    int n6 = 0;
                    for (n4 = 0; n4 < n3; ++n4) {
                        char c = this.text.charAt(n4);
                        if (Character.isWhitespace(c)) {
                            n5 = n4;
                        }
                        if (!((f3 = (float)((double)f3 + ((RectangularShape)(cloneable2 = this.font.getStringBounds(this.text, n4, n4 + 1, FONT_RENDER_CONTEXT))).getWidth())) > (float)this.width) || n5 == -1) continue;
                        n4 = n5;
                        f3 = 0.0f;
                        n5 = -1;
                        if (n4 - 1 - n6 > 0) {
                            cloneable = new StringCharacterIterator(this.text, n6, n4, n6);
                            GlyphVector glyphVector = this.font.createGlyphVector(FONT_RENDER_CONTEXT, (CharacterIterator)cloneable);
                            this.glyphVectors.add((Object)glyphVector);
                            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
                            f = (float)Math.max(rectangle2D.getWidth(), (double)f);
                            f2 = (float)((double)f2 + rectangle2D.getHeight());
                        }
                        n6 = n4 + 1;
                    }
                    if (n4 - 1 - n6 > 0) {
                        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.text, n6, n4, n6);
                        cloneable2 = this.font.createGlyphVector(FONT_RENDER_CONTEXT, stringCharacterIterator);
                        this.glyphVectors.add((Object)cloneable2);
                        cloneable = ((GlyphVector)cloneable2).getLogicalBounds();
                        f = (float)Math.max(cloneable.getWidth(), (double)f);
                        f2 = (float)((double)f2 + cloneable.getHeight());
                    }
                    n2 = (int)Math.ceil(f);
                    n = (int)Math.ceil(f2);
                } else {
                    n2 = this.width;
                    n = 0;
                }
            }
            this.setBounds(0, 0, n2, n);
        }
    }

    public ListenerList<TextListener> getTextListeners() {
        return this.textListeners;
    }

    private static class TextListenerList
    extends ListenerList<TextListener>
    implements TextListener {
        private TextListenerList() {
        }

        @Override
        public void textChanged(Text text, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextListener textListener = (TextListener)iterator.next();
                textListener.textChanged(text, string);
            }
        }

        @Override
        public void fontChanged(Text text, Font font) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextListener textListener = (TextListener)iterator.next();
                textListener.fontChanged(text, font);
            }
        }

        @Override
        public void widthChanged(Text text, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextListener textListener = (TextListener)iterator.next();
                textListener.widthChanged(text, n);
            }
        }

        @Override
        public void alignmentChanged(Text text, HorizontalAlignment horizontalAlignment) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextListener textListener = (TextListener)iterator.next();
                textListener.alignmentChanged(text, horizontalAlignment);
            }
        }
    }
}

