/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.BoxPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class BoxPaneSkin
extends ContainerSkin
implements BoxPaneListener {
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private Insets padding = Insets.NONE;
    private int spacing = 4;
    private boolean fill = false;

    @Override
    public void install(Component component) {
        super.install(component);
        BoxPane boxPane = (BoxPane)component;
        boxPane.getBoxPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n2 = 0;
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            if (n != -1) {
                n = Math.max(n - (this.padding.top + this.padding.bottom), 0);
            }
            int n3 = 0;
            int n4 = boxPane.getLength();
            for (int i = 0; i < n4; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                n2 += component.getPreferredWidth(this.fill ? n : -1);
                ++n3;
            }
            if (n3 > 1) {
                n2 += this.spacing * (n3 - 1);
            }
        } else {
            int n5 = boxPane.getLength();
            for (int i = 0; i < n5; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                n2 = Math.max(n2, component.getPreferredWidth());
            }
        }
        return n2 += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int n) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n2 = 0;
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int n3 = boxPane.getLength();
            for (int i = 0; i < n3; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                n2 = Math.max(n2, component.getPreferredHeight());
            }
        } else {
            if (n != -1) {
                n = Math.max(n - (this.padding.left + this.padding.right), 0);
            }
            int n4 = 0;
            int n5 = boxPane.getLength();
            for (int i = 0; i < n5; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                n2 += component.getPreferredHeight(this.fill ? n : -1);
                ++n4;
            }
            if (n4 > 1) {
                n2 += this.spacing * (n4 - 1);
            }
        }
        return n2 += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n = 0;
        int n2 = 0;
        switch (boxPane.getOrientation()) {
            case HORIZONTAL: {
                int n3 = 0;
                int n4 = boxPane.getLength();
                for (int i = 0; i < n4; ++i) {
                    Component component = boxPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions dimensions = component.getPreferredSize();
                    n += dimensions.width;
                    n2 = Math.max(dimensions.height, n2);
                    ++n3;
                }
                if (n3 <= true) break;
                n += this.spacing * (n3 - 1);
                break;
            }
            case VERTICAL: {
                int n5 = 0;
                int n6 = boxPane.getLength();
                for (int i = 0; i < n6; ++i) {
                    Component component = boxPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions dimensions = component.getPreferredSize();
                    n = Math.max(dimensions.width, n);
                    n2 += dimensions.height;
                    ++n5;
                }
                if (n5 <= true) break;
                n2 += this.spacing * (n5 - 1);
                break;
            }
        }
        return new Dimensions(n += this.padding.left + this.padding.right, n2 += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int n, int n2) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n3 = -1;
        int n4 = 0;
        switch (boxPane.getOrientation()) {
            case HORIZONTAL: {
                if (this.fill) {
                    int n5 = Math.max(n2 - (this.padding.top + this.padding.bottom), 0);
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        int n6 = component.getPreferredWidth(n5);
                        n3 = Math.max(n3, component.getBaseline(n6, n5));
                    }
                } else {
                    n4 = 0;
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        n4 = Math.max(n4, component.getPreferredHeight());
                    }
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        Dimensions dimensions = component.getPreferredSize();
                        int n7 = component.getBaseline(dimensions.width, dimensions.height);
                        if (n7 != -1) {
                            switch (this.verticalAlignment) {
                                case CENTER: {
                                    n7 += (n4 - dimensions.height) / 2;
                                    break;
                                }
                                case BOTTOM: {
                                    n7 += n4 - dimensions.height;
                                }
                            }
                        }
                        n3 = Math.max(n3, n7);
                    }
                }
                break;
            }
            case VERTICAL: {
                int n8 = Math.max(n - (this.padding.left + this.padding.right), 0);
                for (Component component : boxPane) {
                    if (!component.isVisible()) continue;
                    Dimensions dimensions = this.fill ? new Dimensions(n8, component.getPreferredHeight(n8)) : component.getPreferredSize();
                    if (n3 == -1 && (n3 = component.getBaseline(dimensions.width, dimensions.height)) != -1) {
                        n3 += n4;
                    }
                    n4 += dimensions.height + this.spacing;
                }
                n4 -= this.spacing;
                break;
            }
        }
        if (n3 != -1) {
            if (this.fill) {
                n3 += this.padding.top;
            } else {
                switch (this.verticalAlignment) {
                    case TOP: {
                        n3 += this.padding.top;
                        break;
                    }
                    case CENTER: {
                        n3 += (n2 - n4) / 2;
                        break;
                    }
                    case BOTTOM: {
                        n3 += n2 - (n4 + this.padding.bottom);
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public void layout() {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n = boxPane.getLength();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int n4 = this.getPreferredWidth(this.fill ? n3 : -1);
            int n5 = 0;
            switch (this.horizontalAlignment) {
                case CENTER: {
                    n5 = (n2 - n4) / 2;
                    break;
                }
                case RIGHT: {
                    n5 = n2 - n4;
                }
            }
            n5 += this.padding.left;
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                if (this.fill) {
                    n7 = Math.max(n3 - (this.padding.top + this.padding.bottom), 0);
                    n6 = component.getPreferredWidth(n7);
                } else {
                    Dimensions dimensions = component.getPreferredSize();
                    n6 = dimensions.width;
                    n7 = dimensions.height;
                }
                switch (this.verticalAlignment) {
                    case TOP: {
                        n8 = this.padding.top;
                        break;
                    }
                    case CENTER: {
                        n8 = (n3 - n7) / 2;
                        break;
                    }
                    case BOTTOM: {
                        n8 = n3 - this.padding.bottom - n7;
                    }
                }
                component.setSize(n6, n7);
                component.setLocation(n5, n8);
                n5 += n6 + this.spacing;
            }
        } else {
            int n9 = this.getPreferredHeight(this.fill ? n2 : -1);
            int n10 = 0;
            switch (this.verticalAlignment) {
                case CENTER: {
                    n10 = (n3 - n9) / 2;
                    break;
                }
                case BOTTOM: {
                    n10 = n3 - n9;
                }
            }
            n10 += this.padding.top;
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                if (this.fill) {
                    n11 = Math.max(n2 - (this.padding.left + this.padding.right), 0);
                    n12 = component.getPreferredHeight(n11);
                } else {
                    Dimensions dimensions = component.getPreferredSize();
                    n11 = dimensions.width;
                    n12 = dimensions.height;
                }
                switch (this.horizontalAlignment) {
                    case LEFT: {
                        n13 = this.padding.left;
                        break;
                    }
                    case CENTER: {
                        n13 = (n2 - n11) / 2;
                        break;
                    }
                    case RIGHT: {
                        n13 = n2 - this.padding.right - n11;
                    }
                }
                component.setSize(n11, n12);
                component.setLocation(n13, n10);
                n10 += n12 + this.spacing;
            }
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.invalidateComponent();
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.invalidateComponent();
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public final void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(number.intValue());
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.invalidateComponent();
    }

    @Override
    public void orientationChanged(BoxPane boxPane) {
        this.invalidateComponent();
    }
}

