/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.ColorChooserButtonListener;
import org.apache.pivot.wtk.ColorChooserButtonSelectionListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.WindowSkin;

public abstract class ColorChooserButtonSkin
extends ButtonSkin
implements ColorChooserButtonListener,
ColorChooserButtonSelectionListener {
    private ComponentKeyListener colorChooserPopupKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            switch (n) {
                case 27: {
                    ColorChooserButtonSkin.this.colorChooserPopup.close();
                    break;
                }
                case 9: 
                case 10: {
                    Object object;
                    ColorChooserButtonSkin.this.colorChooserPopup.close();
                    if (n == 9) {
                        object = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? Direction.BACKWARD : Direction.FORWARD;
                        colorChooserButton.transferFocus((Direction)((Object)object));
                    }
                    object = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                    colorChooserButton.setSelectedColor((Color)object);
                    break;
                }
            }
            return false;
        }
    };
    private WindowStateListener colorChooserPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)ColorChooserButtonSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)ColorChooserButtonSkin.this.displayMouseListener);
            Window window3 = ColorChooserButtonSkin.this.getComponent().getWindow();
            if (window3 != null) {
                window3.moveToFront();
            }
        }
    };
    private ComponentMouseButtonListener colorChooserMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            if (button == Mouse.Button.LEFT && n3 == 2) {
                ColorChooserButtonSkin.this.colorChooserPopup.close();
                Color color = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                colorChooserButton.setSelectedColor(color);
            }
            return false;
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!ColorChooserButtonSkin.this.colorChooserPopup.isAncestor(component) && component != colorChooserButton) {
                ColorChooserButtonSkin.this.colorChooserPopup.close();
                Color color = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                colorChooserButton.setSelectedColor(color);
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return true;
        }
    };
    protected ColorChooser colorChooser = new ColorChooser();
    protected ColorChooserPopup colorChooserPopup;
    protected boolean pressed = false;

    public ColorChooserButtonSkin() {
        this.colorChooser.getComponentMouseButtonListeners().add((Object)this.colorChooserMouseButtonListener);
        this.colorChooserPopup = new ColorChooserPopup();
        this.colorChooserPopup.getComponentKeyListeners().add((Object)this.colorChooserPopupKeyListener);
        this.colorChooserPopup.getWindowStateListeners().add((Object)this.colorChooserPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        ColorChooserButton colorChooserButton = (ColorChooserButton)component;
        colorChooserButton.getColorChooserButtonListeners().add((Object)this);
        colorChooserButton.getColorChooserButtonSelectionListeners().add((Object)this);
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.colorChooserPopup.close();
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        if (!component.isFocused() && !this.colorChooserPopup.containsFocus()) {
            this.colorChooserPopup.close();
        }
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        this.pressed = true;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        this.pressed = false;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        colorChooserButton.requestFocus();
        colorChooserButton.press();
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 32) {
            this.pressed = true;
            this.repaintComponent();
            bl = true;
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        if (n == 32) {
            this.pressed = false;
            this.repaintComponent();
            colorChooserButton.press();
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public void selectedColorKeyChanged(ColorChooserButton colorChooserButton, String string) {
    }

    @Override
    public void selectedColorChanged(ColorChooserButton colorChooserButton, Color color) {
        Color color2 = colorChooserButton.getSelectedColor();
        colorChooserButton.setButtonData(color2);
        this.colorChooser.setSelectedColor(color2);
    }

    public final class ColorChooserPopupSkin
    extends WindowSkin {
        private ColorChooserPopupSkin() {
        }

        @Override
        public boolean isFocusable() {
            return true;
        }

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            component.requestFocus();
            return super.mouseClick(component, button, n, n2, n3);
        }
    }

    public final class ColorChooserPopup
    extends Window {
        private ColorChooserPopup() {
            this.setSkin(new ColorChooserPopupSkin());
        }
    }
}

