/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.skin.ComponentSkin;

public abstract class ContainerSkin
extends ComponentSkin
implements ContainerListener,
ContainerMouseListener {
    private Paint backgroundPaint = null;
    private static FocusTraversalPolicy DEFAULT_FOCUS_TRAVERSAL_POLICY = new IndexFocusTraversalPolicy();

    @Override
    public void install(Component component) {
        super.install(component);
        Container container = (Container)component;
        container.getContainerListeners().add((Object)this);
        container.getContainerMouseListeners().add((Object)this);
        container.setFocusTraversalPolicy(DEFAULT_FOCUS_TRAVERSAL_POLICY);
    }

    @Override
    public int getPreferredWidth(int n) {
        return 0;
    }

    @Override
    public int getPreferredHeight(int n) {
        return 0;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundPaint != null && this.backgroundPaint.getTransparency() == 1;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.repaintComponent();
    }

    public final void setBackgroundPaint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundPaint is null");
        }
        this.setBackgroundPaint(GraphicsUtilities.decodePaint(string));
    }

    public final void setBackgroundPaint(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("backgroundPaint is null");
        }
        this.setBackgroundPaint(GraphicsUtilities.decodePaint(dictionary));
    }

    public Color getBackgroundColor() {
        if (this.backgroundPaint != null && !(this.backgroundPaint instanceof Color)) {
            throw new IllegalStateException("Background paint is not a Color.");
        }
        return (Color)this.backgroundPaint;
    }

    public void setBackgroundColor(Color color) {
        this.setBackgroundPaint(color);
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    @Override
    public void componentInserted(Container container, int n) {
    }

    @Override
    public void componentsRemoved(Container container, int n, Sequence<Component> sequence) {
    }

    @Override
    public void componentMoved(Container container, int n, int n2) {
    }

    @Override
    public void contextKeyChanged(Container container, String string) {
    }

    @Override
    public void focusTraversalPolicyChanged(Container container, FocusTraversalPolicy focusTraversalPolicy) {
    }

    @Override
    public boolean mouseMove(Container container, int n, int n2) {
        return false;
    }

    @Override
    public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
        return false;
    }

    @Override
    public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
        return false;
    }

    @Override
    public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        return false;
    }

    public static class IndexFocusTraversalPolicy
    implements FocusTraversalPolicy {
        private boolean wrap;

        public IndexFocusTraversalPolicy() {
            this(false);
        }

        public IndexFocusTraversalPolicy(boolean bl) {
            this.wrap = bl;
        }

        @Override
        public Component getNextComponent(Container container, Component component, Direction direction) {
            if (container == null) {
                throw new IllegalArgumentException("container is null.");
            }
            if (direction == null) {
                throw new IllegalArgumentException("direction is null.");
            }
            Component component2 = null;
            int n = container.getLength();
            if (n > 0) {
                switch (direction) {
                    case FORWARD: {
                        if (component == null) {
                            component2 = container.get(0);
                            break;
                        }
                        int n2 = container.indexOf(component);
                        if (n2 == -1) {
                            throw new IllegalArgumentException();
                        }
                        if (n2 < n - 1) {
                            component2 = container.get(n2 + 1);
                            break;
                        }
                        if (!this.wrap) break;
                        component2 = container.get(0);
                        break;
                    }
                    case BACKWARD: {
                        if (component == null) {
                            component2 = container.get(n - 1);
                            break;
                        }
                        int n3 = container.indexOf(component);
                        if (n3 == -1) {
                            throw new IllegalArgumentException();
                        }
                        if (n3 > 0) {
                            component2 = container.get(n3 - 1);
                            break;
                        }
                        if (!this.wrap) break;
                        component2 = container.get(n - 1);
                    }
                }
            }
            return component2;
        }
    }
}

