/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.GridPaneListener;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class GridPaneSkin
extends ContainerSkin
implements GridPane.Skin,
GridPaneListener {
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean showHorizontalGridLines = false;
    private boolean showVerticalGridLines = false;
    private Color horizontalGridColor = Color.BLACK;
    private Color verticalGridColor = Color.BLACK;
    private int cellWidth = 0;
    private int cellHeight = 0;

    @Override
    public void install(Component component) {
        super.install(component);
        GridPane gridPane = (GridPane)component;
        gridPane.getGridPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2;
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n3 = gridPane.getColumnCount();
        int n4 = rowSequence.getLength();
        Metadata metadata = new Metadata();
        int n5 = this.getCellHeight(n, metadata);
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            GridPane.Row row = rowSequence.get(n2);
            int n7 = row.getLength();
            for (int i = 0; i < n7 && i < n3; ++i) {
                Component component = row.get(i);
                if (component == null || !component.isVisible()) continue;
                n6 = Math.max(n6, component.getPreferredWidth(n5));
            }
        }
        n2 = this.padding.left + this.padding.right + metadata.visibleColumnCount * n6;
        if (metadata.visibleColumnCount > 1) {
            n2 += (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
        }
        return n2;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n3 = gridPane.getColumnCount();
        int n4 = rowSequence.getLength();
        Metadata metadata = new Metadata();
        int n5 = this.getCellWidth(n, metadata);
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            GridPane.Row row = rowSequence.get(n2);
            int n7 = row.getLength();
            for (int i = 0; i < n7 && i < n3; ++i) {
                Component component = row.get(i);
                if (component == null || !component.isVisible()) continue;
                n6 = Math.max(n6, component.getPreferredHeight(n5));
            }
        }
        n2 = this.padding.top + this.padding.bottom + metadata.visibleRowCount * n6;
        if (metadata.visibleRowCount > 1) {
            n2 += (metadata.visibleRowCount - 1) * this.verticalSpacing;
        }
        return n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        int n;
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n2 = gridPane.getColumnCount();
        int n3 = rowSequence.getLength();
        Metadata metadata = new Metadata();
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            GridPane.Row row = rowSequence.get(n);
            int n6 = row.getLength();
            for (int i = 0; i < n6 && i < n2; ++i) {
                Component component = row.get(i);
                if (component == null || !component.isVisible()) continue;
                Dimensions dimensions = component.getPreferredSize();
                n4 = Math.max(n4, dimensions.height);
                n5 = Math.max(n5, dimensions.width);
            }
        }
        n = this.padding.left + this.padding.right + metadata.visibleColumnCount * n5;
        if (metadata.visibleColumnCount > 1) {
            n += (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
        }
        int n7 = this.padding.top + this.padding.bottom + metadata.visibleRowCount * n4;
        if (metadata.visibleRowCount > 1) {
            n7 += (metadata.visibleRowCount - 1) * this.verticalSpacing;
        }
        return new Dimensions(n, n7);
    }

    @Override
    public int getBaseline(int n, int n2) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n3 = gridPane.getColumnCount();
        int n4 = rowSequence.getLength();
        Metadata metadata = new Metadata();
        int n5 = this.getCellWidth(n, metadata);
        int n6 = this.getCellHeight(n2, metadata);
        int n7 = -1;
        int n8 = this.padding.top;
        for (int i = 0; i < n4 && n7 == -1; ++i) {
            if (!metadata.isRowVisible(i)) continue;
            GridPane.Row row = rowSequence.get(i);
            int n9 = row.getLength();
            for (int j = 0; j < n9 && j < n3 && n7 == -1; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (n7 = component.getBaseline(n5, n6)) == -1) continue;
                n7 += n8;
            }
            n8 += n6 + this.verticalSpacing;
        }
        return n7;
    }

    @Override
    public void layout() {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n = gridPane.getColumnCount();
        int n2 = rowSequence.getLength();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Metadata metadata = new Metadata();
        this.cellWidth = this.getCellWidth(n3, metadata);
        this.cellHeight = this.getCellHeight(n4, metadata);
        int n5 = this.padding.top;
        for (int i = 0; i < n2; ++i) {
            if (!metadata.isRowVisible(i)) continue;
            GridPane.Row row = rowSequence.get(i);
            int n6 = this.padding.left;
            int n7 = row.getLength();
            for (int j = 0; j < n7 && j < n; ++j) {
                Component component = row.get(j);
                if (component != null && component.isVisible()) {
                    component.setLocation(n6, n5);
                    component.setSize(this.cellWidth, this.cellHeight);
                }
                if (!metadata.isColumnVisible(j)) continue;
                n6 += this.cellWidth + this.horizontalSpacing;
            }
            n5 += this.cellHeight + this.verticalSpacing;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        super.paint(graphics2D);
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n4 = gridPane.getColumnCount();
        int n5 = rowSequence.getLength();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        Metadata metadata = new Metadata();
        if (this.showHorizontalGridLines && this.verticalSpacing > 0 && n5 > 1) {
            graphics2D.setPaint(this.horizontalGridColor);
            n3 = this.padding.top + (this.cellHeight + this.verticalSpacing);
            for (n2 = 1; n2 < n5; ++n2) {
                if (!metadata.isRowVisible(n2 - 1)) continue;
                n = Math.max(n3 - (int)Math.ceil((float)this.verticalSpacing * 0.5f), 0);
                GraphicsUtilities.drawLine(graphics2D, 0, n, n6, Orientation.HORIZONTAL);
                n3 += this.cellHeight + this.verticalSpacing;
            }
        }
        if (this.showVerticalGridLines && this.horizontalSpacing > 0 && n4 > 1) {
            graphics2D.setPaint(this.verticalGridColor);
            n3 = this.padding.left + (this.cellWidth + this.horizontalSpacing);
            for (n2 = 1; n2 < n4; ++n2) {
                if (!metadata.isRowVisible(n2 - 1)) continue;
                n = Math.max(n3 - (int)Math.ceil((double)this.horizontalSpacing * 0.5), 0);
                GraphicsUtilities.drawLine(graphics2D, n, 0, n7, Orientation.VERTICAL);
                n3 += this.cellWidth + this.horizontalSpacing;
            }
        }
    }

    private int getCellWidth(int n, Metadata metadata) {
        int n2 = -1;
        if (n != -1) {
            int n3 = n - this.padding.left - this.padding.right;
            if (metadata.visibleColumnCount > 1) {
                n3 -= (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
            }
            n3 = Math.max(0, n3);
            n2 = metadata.visibleColumnCount == 0 ? 0 : n3 / metadata.visibleColumnCount;
        }
        return n2;
    }

    private int getCellHeight(int n, Metadata metadata) {
        int n2 = -1;
        if (n != -1) {
            int n3 = n - this.padding.top - this.padding.bottom;
            if (metadata.visibleRowCount > 1) {
                n3 -= (metadata.visibleRowCount - 1) * this.verticalSpacing;
            }
            n3 = Math.max(0, n3);
            n2 = metadata.visibleRowCount == 0 ? 0 : n3 / metadata.visibleRowCount;
        }
        return n2;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative");
        }
        this.horizontalSpacing = n;
        this.invalidateComponent();
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative");
        }
        this.verticalSpacing = n;
        this.invalidateComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean bl) {
        this.showHorizontalGridLines = bl;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean bl) {
        this.showVerticalGridLines = bl;
        this.repaintComponent();
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = color;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setHorizontalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = color;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setVerticalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor(string));
    }

    @Override
    public int getRowAt(int n) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n2 = rowSequence.getLength();
        int n3 = -1;
        int n4 = this.padding.top;
        for (int i = 0; n4 <= n && i < n2; n4 += this.cellHeight + this.verticalSpacing, ++i) {
            if (n >= n4 + this.cellHeight) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    @Override
    public Bounds getRowBounds(int n) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rowSequence = gridPane.getRows();
        int n2 = rowSequence.getLength();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.padding.top;
        for (int i = 0; i < n; ++i) {
            n3 += this.cellHeight + this.verticalSpacing;
        }
        return new Bounds(0, n3, this.getWidth(), this.cellHeight);
    }

    @Override
    public int getColumnAt(int n) {
        GridPane gridPane = (GridPane)this.getComponent();
        int n2 = gridPane.getColumnCount();
        int n3 = -1;
        int n4 = 0;
        for (int i = this.padding.left; i <= n && n4 < n2; i += this.cellWidth + this.horizontalSpacing, ++n4) {
            if (n >= i + this.cellWidth) continue;
            n3 = n4;
            break;
        }
        return n3;
    }

    @Override
    public Bounds getColumnBounds(int n) {
        GridPane gridPane = (GridPane)this.getComponent();
        int n2 = gridPane.getColumnCount();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.padding.left;
        for (int i = 0; i < n; ++i) {
            n3 += this.cellWidth + this.horizontalSpacing;
        }
        return new Bounds(n3, 0, this.cellWidth, this.getHeight());
    }

    @Override
    public void columnCountChanged(GridPane gridPane, int n) {
        this.invalidateComponent();
    }

    @Override
    public void rowInserted(GridPane gridPane, int n) {
        this.invalidateComponent();
    }

    @Override
    public void rowsRemoved(GridPane gridPane, int n, Sequence<GridPane.Row> sequence) {
        this.invalidateComponent();
    }

    @Override
    public void cellInserted(GridPane.Row row, int n) {
        this.invalidateComponent();
    }

    @Override
    public void cellsRemoved(GridPane.Row row, int n, Sequence<Component> sequence) {
        this.invalidateComponent();
    }

    @Override
    public void cellUpdated(GridPane.Row row, int n, Component component) {
        this.invalidateComponent();
    }

    protected final class Metadata {
        public final int visibleRowCount;
        public final int visibleColumnCount;
        private boolean[] visibleRows;
        private boolean[] visibleColumns;

        public Metadata() {
            GridPane gridPane = (GridPane)GridPaneSkin.this.getComponent();
            GridPane.RowSequence rowSequence = gridPane.getRows();
            int n = gridPane.getColumnCount();
            int n2 = rowSequence.getLength();
            this.visibleRows = new boolean[n2];
            this.visibleColumns = new boolean[n];
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                GridPane.Row row = rowSequence.get(i);
                int n5 = row.getLength();
                for (int j = 0; j < n5 && j < n; ++j) {
                    Component component = row.get(j);
                    if (component == null || !component.isVisible()) continue;
                    if (!this.visibleRows[i]) {
                        ++n3;
                        this.visibleRows[i] = true;
                    }
                    if (this.visibleColumns[j]) continue;
                    ++n4;
                    this.visibleColumns[j] = true;
                }
            }
            this.visibleRowCount = n3;
            this.visibleColumnCount = n4;
        }

        public boolean isRowVisible(int n) {
            return this.visibleRows[n];
        }

        public boolean isColumnVisible(int n) {
            return this.visibleColumns[n];
        }
    }
}

