/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.List;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonListener;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class ListButtonSkin
extends ButtonSkin
implements ListButtonListener,
ListButtonSelectionListener {
    protected ListView listView;
    protected Window listViewPopup;
    private ComponentMouseButtonListener listViewPopupMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            ListButton listButton = (ListButton)ListButtonSkin.this.getComponent();
            ListButtonSkin.this.listViewPopup.close();
            int n4 = ListButtonSkin.this.listView.getSelectedIndex();
            listButton.setSelectedIndex(n4);
            return true;
        }
    };
    private ComponentKeyListener listViewPopupKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            ListButton listButton = (ListButton)ListButtonSkin.this.getComponent();
            switch (n) {
                case 27: {
                    ListButtonSkin.this.listViewPopup.close();
                    break;
                }
                case 9: 
                case 10: {
                    ListButtonSkin.this.listViewPopup.close();
                    if (n == 9) {
                        Direction direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? Direction.BACKWARD : Direction.FORWARD;
                        listButton.transferFocus(direction);
                    }
                    int n2 = ListButtonSkin.this.listView.getSelectedIndex();
                    listButton.setSelectedIndex(n2);
                    break;
                }
            }
            return false;
        }
    };
    private WindowStateListener listViewPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)ListButtonSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)ListButtonSkin.this.displayMouseListener);
            Window window3 = ListButtonSkin.this.getComponent().getWindow();
            if (window3 != null) {
                window3.moveToFront();
            }
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!ListButtonSkin.this.listViewPopup.isAncestor(component) && component != ListButtonSkin.this.getComponent()) {
                ListButtonSkin.this.listViewPopup.close();
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            boolean bl = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n3, n4);
            if (window != ListButtonSkin.this.listViewPopup) {
                bl = true;
            }
            return bl;
        }
    };
    protected boolean pressed = false;

    public ListButtonSkin() {
        this.listView = new ListView();
        this.listViewPopup = new Window();
        this.listViewPopup.getComponentMouseButtonListeners().add((Object)this.listViewPopupMouseButtonListener);
        this.listViewPopup.getComponentKeyListeners().add((Object)this.listViewPopupKeyListener);
        this.listViewPopup.getWindowStateListeners().add((Object)this.listViewPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        ListButton listButton = (ListButton)component;
        listButton.getListButtonListeners().add((Object)this);
        listButton.getListButtonSelectionListeners().add((Object)this);
        this.listView.setListData(listButton.getListData());
        this.listView.setItemRenderer(listButton.getItemRenderer());
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.listViewPopup.close();
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        if (!component.isFocused() && !this.listViewPopup.containsFocus()) {
            this.listViewPopup.close();
        }
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        this.pressed = true;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        this.pressed = false;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        ListButton listButton = (ListButton)this.getComponent();
        listButton.requestFocus();
        listButton.press();
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 32) {
            this.pressed = true;
            this.repaintComponent();
            bl = true;
        } else if (n == 38) {
            ListButton listButton = (ListButton)this.getComponent();
            int n2 = listButton.getSelectedIndex();
            if (n2 > 0) {
                listButton.setSelectedIndex(n2 - 1);
                bl = true;
            }
        } else if (n == 40) {
            ListButton listButton = (ListButton)this.getComponent();
            int n3 = listButton.getSelectedIndex();
            if (n3 < listButton.getListData().getLength() - 1) {
                listButton.setSelectedIndex(n3 + 1);
                bl = true;
            }
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        ListButton listButton = (ListButton)this.getComponent();
        if (n == 32) {
            this.pressed = false;
            this.repaintComponent();
            listButton.press();
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public void listDataChanged(ListButton listButton, List<?> list) {
        this.listView.setListData(listButton.getListData());
    }

    @Override
    public void itemRendererChanged(ListButton listButton, ListView.ItemRenderer itemRenderer) {
        this.listView.setItemRenderer(listButton.getItemRenderer());
    }

    @Override
    public void disabledItemFilterChanged(ListButton listButton, Filter<?> filter) {
        this.listView.setDisabledItemFilter(listButton.getDisabledItemFilter());
    }

    @Override
    public void selectedItemKeyChanged(ListButton listButton, String string) {
    }

    @Override
    public void selectedIndexChanged(ListButton listButton, int n) {
        int n2 = listButton.getSelectedIndex();
        Object object = n2 == -1 ? null : listButton.getListData().get(n2);
        listButton.setButtonData(object);
        this.listView.setSelectedIndex(n2);
    }
}

