/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.MenuButtonListener;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuButtonSkin
extends ButtonSkin
implements MenuButtonListener {
    protected boolean pressed = false;
    protected MenuPopup menuPopup = new MenuPopup();
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuButtonSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)MenuButtonSkin.this.displayMouseListener);
            Window window3 = MenuButtonSkin.this.getComponent().getWindow();
            window3.moveToFront();
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Component component = display.getDescendantAt(n, n2);
            if (!MenuButtonSkin.this.menuPopup.isAncestor(component) && component != MenuButtonSkin.this.getComponent()) {
                MenuButtonSkin.this.menuPopup.close();
            }
            return false;
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        MenuButton menuButton = (MenuButton)this.getComponent();
        menuButton.getMenuButtonListeners().add((Object)this);
        this.menuPopup.setMenu(menuButton.getMenu());
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.menuPopup.close();
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        if (!component.isFocused() && !this.menuPopup.containsFocus()) {
            this.menuPopup.close();
        }
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        this.pressed = true;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        this.pressed = false;
        this.repaintComponent();
        return bl;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        menuButton.press();
        if (this.menuPopup.isShowing()) {
            this.menuPopup.requestFocus();
        }
        return true;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (n == 32) {
            this.pressed = true;
            this.repaintComponent();
            bl = true;
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        MenuButton menuButton = (MenuButton)this.getComponent();
        if (n == 32) {
            this.pressed = false;
            this.repaintComponent();
            menuButton.press();
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }

    @Override
    public void menuChanged(MenuButton menuButton, Menu menu) {
        this.menuPopup.setMenu(menuButton.getMenu());
    }

    @Override
    public void repeatableChanged(MenuButton menuButton) {
        this.invalidateComponent();
    }
}

