/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.ScrollPaneListener;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class ScrollPaneSkin
extends ContainerSkin
implements Viewport.Skin,
ScrollPaneListener,
ViewportListener,
ScrollBarValueListener {
    private ScrollBar horizontalScrollBar = new ScrollBar(Orientation.HORIZONTAL);
    private ScrollBar verticalScrollBar = new ScrollBar(Orientation.VERTICAL);
    private ScrollPane.Corner topLeftCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.TOP_LEFT);
    private ScrollPane.Corner bottomLeftCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.BOTTOM_LEFT);
    private ScrollPane.Corner bottomRightCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.BOTTOM_RIGHT);
    private ScrollPane.Corner topRightCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.TOP_RIGHT);
    private int horizontalReveal = 30;
    private int verticalReveal = 30;
    private int cachedHorizontalScrollBarHeight = 0;
    private int cachedVerticalScrollBarWidth = 0;
    private boolean optimizeScrolling = true;
    private static final int DEFAULT_HORIZONTAL_INCREMENT = 10;
    private static final int DEFAULT_VERTICAL_INCREMENT = 10;

    public ScrollPaneSkin() {
        this.setBackgroundPaint(Color.WHITE);
        this.horizontalScrollBar.setUnitIncrement(10);
        this.verticalScrollBar.setUnitIncrement(10);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        ScrollPane scrollPane = (ScrollPane)component;
        scrollPane.getViewportListeners().add((Object)this);
        scrollPane.getScrollPaneListeners().add((Object)this);
        scrollPane.add(this.horizontalScrollBar);
        scrollPane.add(this.verticalScrollBar);
        scrollPane.add(this.topLeftCorner);
        scrollPane.add(this.bottomLeftCorner);
        scrollPane.add(this.bottomRightCorner);
        scrollPane.add(this.topRightCorner);
        this.horizontalScrollBar.getScrollBarValueListeners().add((Object)this);
        this.verticalScrollBar.getScrollBarValueListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2 = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component = scrollPane.getView();
        if (component != null) {
            ScrollPane.ScrollBarPolicy scrollBarPolicy;
            int n3 = 0;
            Component component2 = scrollPane.getRowHeader();
            if (component2 != null) {
                n3 = component2.getPreferredWidth(-1);
            }
            int n4 = 0;
            Component component3 = scrollPane.getColumnHeader();
            if (component3 != null) {
                n4 = component3.getPreferredHeight(-1);
            }
            if ((scrollBarPolicy = scrollPane.getVerticalScrollBarPolicy()) != ScrollPane.ScrollBarPolicy.FILL) {
                Dimensions dimensions = component.getPreferredSize();
                if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
                    int n5;
                    scrollBarPolicy = n < 0 ? ScrollPane.ScrollBarPolicy.AUTO : ((n5 = dimensions.height + n4) < n ? ScrollPane.ScrollBarPolicy.FILL : ScrollPane.ScrollBarPolicy.AUTO);
                }
                if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy == ScrollPane.ScrollBarPolicy.NEVER || scrollBarPolicy == ScrollPane.ScrollBarPolicy.AUTO) {
                    n2 = dimensions.width + n3;
                    if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy == ScrollPane.ScrollBarPolicy.AUTO && n > 0 && dimensions.height + n4 > n) {
                        n2 += this.verticalScrollBar.getPreferredWidth(-1);
                    }
                }
            }
            if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL) {
                if (n >= 0) {
                    n = Math.max(n - n4, 0);
                }
                n2 = component.getPreferredWidth(n) + n3;
            }
        }
        return n2;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2 = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component = scrollPane.getView();
        if (component != null) {
            ScrollPane.ScrollBarPolicy scrollBarPolicy;
            int n3 = 0;
            Component component2 = scrollPane.getRowHeader();
            if (component2 != null) {
                n3 = component2.getPreferredWidth(-1);
            }
            int n4 = 0;
            Component component3 = scrollPane.getColumnHeader();
            if (component3 != null) {
                n4 = component3.getPreferredHeight(-1);
            }
            if ((scrollBarPolicy = scrollPane.getHorizontalScrollBarPolicy()) != ScrollPane.ScrollBarPolicy.FILL) {
                Dimensions dimensions = component.getPreferredSize();
                if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
                    int n5;
                    scrollBarPolicy = n < 0 ? ScrollPane.ScrollBarPolicy.AUTO : ((n5 = dimensions.width + n3) < n ? ScrollPane.ScrollBarPolicy.FILL : ScrollPane.ScrollBarPolicy.AUTO);
                }
                if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy == ScrollPane.ScrollBarPolicy.NEVER || scrollBarPolicy == ScrollPane.ScrollBarPolicy.AUTO) {
                    n2 = dimensions.height + n4;
                    if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy == ScrollPane.ScrollBarPolicy.AUTO && n > 0 && dimensions.width + n3 > n) {
                        n2 += this.horizontalScrollBar.getPreferredHeight(-1);
                    }
                }
            }
            if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL) {
                if (n >= 0) {
                    n = Math.max(n - n3, 0);
                }
                n2 = component.getPreferredHeight(n) + n4;
            }
        }
        return n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int n = 0;
        int n2 = 0;
        Component component = scrollPane.getView();
        if (component != null) {
            Component component2;
            Dimensions dimensions = component.getPreferredSize();
            n += dimensions.width;
            n2 += dimensions.height;
            Component component3 = scrollPane.getRowHeader();
            if (component3 != null) {
                n += component3.getPreferredWidth(-1);
            }
            if ((component2 = scrollPane.getColumnHeader()) != null) {
                n2 += component2.getPreferredHeight(-1);
            }
            if (scrollPane.getHorizontalScrollBarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                n2 += this.horizontalScrollBar.getPreferredHeight(-1);
            }
            if (scrollPane.getVerticalScrollBarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                n += this.verticalScrollBar.getPreferredWidth(-1);
            }
        }
        return new Dimensions(n, n2);
    }

    @Override
    public int getBaseline(int n, int n2) {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component = scrollPane.getView();
        Component component2 = scrollPane.getRowHeader();
        Component component3 = scrollPane.getColumnHeader();
        int n3 = -1;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (component2 != null) {
            n6 = component2.getPreferredWidth(-1);
            n4 -= n6;
        }
        int n7 = 0;
        if (component3 != null) {
            n7 = component3.getPreferredHeight(-1);
            n5 -= n7;
            n3 = component3.getBaseline(n4, n7);
        }
        if (n3 == -1 && component2 != null && (n3 = component2.getBaseline(n6, n5)) != -1) {
            n3 += n7;
        }
        if (n3 == -1 && component != null && (n3 = component.getBaseline(n4, n5)) != -1) {
            n3 += n7;
        }
        return n3;
    }

    @Override
    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        boolean bl = false;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component2 = scrollPane.getView();
        if (component2 != null) {
            if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                int n5 = scrollPane.getScrollLeft();
                int n6 = n5 + n * n2 * this.horizontalScrollBar.getUnitIncrement();
                if (n2 > 0) {
                    int n7 = this.getMaxScrollLeft();
                    n6 = Math.min(n6, n7);
                    if (n5 < n7) {
                        bl = true;
                    }
                } else {
                    n6 = Math.max(n6, 0);
                    if (n5 > 0) {
                        bl = true;
                    }
                }
                scrollPane.setScrollLeft(n6);
            } else {
                int n8 = scrollPane.getScrollTop();
                int n9 = n8 + n * n2 * this.verticalScrollBar.getUnitIncrement();
                if (n2 > 0) {
                    int n10 = this.getMaxScrollTop();
                    n9 = Math.min(n9, n10);
                    if (n8 < n10) {
                        bl = true;
                    }
                } else {
                    n9 = Math.max(n9, 0);
                    if (n8 > 0) {
                        bl = true;
                    }
                }
                scrollPane.setScrollTop(n9);
            }
        }
        return bl;
    }

    @Override
    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        if (!bl) {
            ScrollPane scrollPane = (ScrollPane)this.getComponent();
            int n2 = scrollPane.getScrollTop();
            int n3 = scrollPane.getScrollLeft();
            if (n == 38) {
                int n4 = Math.max(n2 - this.verticalScrollBar.getUnitIncrement(), 0);
                scrollPane.setScrollTop(n4);
                bl = n4 != n2;
            } else if (n == 40) {
                int n5 = Math.min(n2 + this.verticalScrollBar.getUnitIncrement(), this.getMaxScrollTop());
                scrollPane.setScrollTop(n5);
                bl = n5 != n2;
            } else if (n == 37) {
                int n6 = Math.max(n3 - this.horizontalScrollBar.getUnitIncrement(), 0);
                scrollPane.setScrollLeft(n6);
                bl = n6 != n3;
            } else if (n == 39) {
                int n7 = Math.min(n3 + this.horizontalScrollBar.getUnitIncrement(), this.getMaxScrollLeft());
                scrollPane.setScrollLeft(n7);
                bl = n7 != n3;
            } else if (n == 33) {
                int n8 = this.verticalScrollBar.getBlockIncrement();
                int n9 = Math.max(n2 - n8, 0);
                scrollPane.setScrollTop(n9);
                bl = n9 != n2;
            } else if (n == 34) {
                int n10 = this.verticalScrollBar.getBlockIncrement();
                int n11 = Math.min(n2 + n10, this.getMaxScrollTop());
                scrollPane.setScrollTop(n11);
                bl = n11 != n2;
            }
        }
        return bl;
    }

    private int getMaxScrollTop() {
        int n = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component = scrollPane.getView();
        if (component != null) {
            int n2 = component.getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = this.getHeight();
            Component component2 = scrollPane.getColumnHeader();
            if (component2 != null) {
                n3 = component2.getHeight();
            }
            if (this.horizontalScrollBar.isVisible()) {
                n4 = this.horizontalScrollBar.getHeight();
            }
            n = Math.max(n2 + n3 + n4 - n5, 0);
        }
        return n;
    }

    private int getMaxScrollLeft() {
        int n = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component = scrollPane.getView();
        if (component != null) {
            int n2 = component.getWidth();
            int n3 = 0;
            int n4 = 0;
            int n5 = this.getWidth();
            Component component2 = scrollPane.getRowHeader();
            if (component2 != null) {
                n3 = component2.getWidth();
            }
            if (this.verticalScrollBar.isVisible()) {
                n4 = this.verticalScrollBar.getWidth();
            }
            n = Math.max(n2 + n3 + n4 - n5, 0);
        }
        return n;
    }

    @Override
    public void layout() {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        ScrollPane.ScrollBarPolicy scrollBarPolicy = scrollPane.getHorizontalScrollBarPolicy();
        ScrollPane.ScrollBarPolicy scrollBarPolicy2 = scrollPane.getVerticalScrollBarPolicy();
        boolean bl = false;
        boolean bl2 = false;
        if (scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
            scrollBarPolicy = ScrollPane.ScrollBarPolicy.AUTO;
            bl = true;
        }
        if (scrollBarPolicy2 == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
            scrollBarPolicy2 = ScrollPane.ScrollBarPolicy.AUTO;
            bl2 = true;
        }
        this.layoutHelper(scrollBarPolicy, scrollBarPolicy2);
        Component component = scrollPane.getView();
        if (component != null && (bl || bl2)) {
            int n;
            int n2;
            int n3;
            Component component2;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl) {
                component2 = scrollPane.getRowHeader();
                n3 = component2 != null ? component2.getWidth() : 0;
                n2 = this.verticalScrollBar.isVisible() ? this.verticalScrollBar.getWidth() : 0;
                n = this.getWidth() - n3 - n2;
                if (component.getWidth() < n) {
                    scrollBarPolicy = ScrollPane.ScrollBarPolicy.FILL;
                    bl3 = true;
                }
            }
            if (bl2) {
                component2 = scrollPane.getColumnHeader();
                n3 = component2 != null ? component2.getHeight() : 0;
                n2 = this.horizontalScrollBar.isVisible() ? this.horizontalScrollBar.getHeight() : 0;
                n = this.getHeight() - n3 - n2;
                if (component.getHeight() < n) {
                    scrollBarPolicy2 = ScrollPane.ScrollBarPolicy.FILL;
                    bl4 = true;
                }
            }
            if (bl3 || bl4) {
                this.layoutHelper(scrollBarPolicy, scrollBarPolicy2);
            }
        }
        this.cachedHorizontalScrollBarHeight = this.horizontalScrollBar.getHeight();
        this.cachedVerticalScrollBarWidth = this.verticalScrollBar.getWidth();
    }

    private void layoutHelper(ScrollPane.ScrollBarPolicy scrollBarPolicy, ScrollPane.ScrollBarPolicy scrollBarPolicy2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        boolean bl = scrollBarPolicy == ScrollPane.ScrollBarPolicy.FILL;
        boolean bl2 = scrollBarPolicy2 == ScrollPane.ScrollBarPolicy.FILL;
        Component component = scrollPane.getView();
        Component component2 = scrollPane.getColumnHeader();
        Component component3 = scrollPane.getRowHeader();
        Component component4 = scrollPane.getCorner();
        int n9 = 0;
        if (component3 != null) {
            n9 = component3.getPreferredWidth(-1);
        }
        int n10 = 0;
        if (component2 != null) {
            n10 = component2.getPreferredHeight(-1);
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = this.cachedHorizontalScrollBarHeight;
        int n14 = this.cachedVerticalScrollBarWidth;
        int n15 = 0;
        do {
            n6 = n11;
            n5 = n12;
            n4 = n13;
            n3 = n14;
            if (component != null) {
                if (bl && bl2) {
                    n11 = Math.max(n7 - n9 - n14, 0);
                    n12 = Math.max(n8 - n10 - n13, 0);
                } else if (bl) {
                    n11 = Math.max(n7 - n9 - n14, 0);
                    n12 = component.getPreferredHeight(n11);
                } else if (bl2) {
                    n12 = Math.max(n8 - n10 - n13, 0);
                    n11 = component.getPreferredWidth(n12);
                } else {
                    Dimensions dimensions = component.getPreferredSize();
                    n11 = dimensions.width;
                    n12 = dimensions.height;
                }
            }
            n13 = scrollBarPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy == ScrollPane.ScrollBarPolicy.AUTO && n11 > n7 - n9 - n14 ? this.horizontalScrollBar.getPreferredHeight(-1) : 0;
            n14 = scrollBarPolicy2 == ScrollPane.ScrollBarPolicy.ALWAYS || scrollBarPolicy2 == ScrollPane.ScrollBarPolicy.AUTO && n12 > n8 - n10 - n13 ? this.verticalScrollBar.getPreferredWidth(-1) : 0;
            if (++n15 <= 4) continue;
            System.err.println("Breaking out of potential infinite loop");
            break;
        } while (n11 != n6 || n12 != n5 || n13 != n4 || n14 != n3);
        int n16 = scrollPane.getScrollTop();
        int n17 = scrollPane.getScrollLeft();
        if (component != null) {
            component.setSize(n11, n12);
            component.setLocation(n9 - n17, n10 - n16);
        }
        if (component2 != null) {
            component2.setSize(n11, n10);
            component2.setLocation(n9 - n17, 0);
        }
        if (component3 != null) {
            component3.setSize(n9, n12);
            component3.setLocation(0, n10 - n16);
        }
        if (n13 > 0) {
            this.horizontalScrollBar.setVisible(true);
            n2 = Math.max(n7 - n9 - n14, 0);
            this.horizontalScrollBar.setSize(n2, n13);
            this.horizontalScrollBar.setLocation(n9, n8 - n13);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
        if (n14 > 0) {
            this.verticalScrollBar.setVisible(true);
            n2 = Math.max(n8 - n10 - n13, 0);
            this.verticalScrollBar.setSize(n14, n2);
            this.verticalScrollBar.setLocation(n7 - n14, n10);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        if (n10 > 0 && n9 > 0) {
            if (component4 != null) {
                component4.setVisible(true);
                component4.setSize(n9, n10);
                component4.setLocation(0, 0);
                this.topLeftCorner.setVisible(false);
            } else {
                this.topLeftCorner.setVisible(true);
                this.topLeftCorner.setSize(n9, n10);
                this.topLeftCorner.setLocation(0, 0);
            }
        } else {
            if (component4 != null) {
                component4.setVisible(false);
            }
            this.topLeftCorner.setVisible(false);
        }
        if (n9 > 0 && n13 > 0) {
            this.bottomLeftCorner.setVisible(true);
            this.bottomLeftCorner.setSize(n9, n13);
            this.bottomLeftCorner.setLocation(0, n8 - n13);
        } else {
            this.bottomLeftCorner.setVisible(false);
        }
        if (n14 > 0 && n13 > 0) {
            this.bottomRightCorner.setVisible(true);
            this.bottomRightCorner.setSize(n14, n13);
            this.bottomRightCorner.setLocation(n7 - n14, n8 - n13);
        } else {
            this.bottomRightCorner.setVisible(false);
        }
        if (n10 > 0 && n14 > 0) {
            this.topRightCorner.setVisible(true);
            this.topRightCorner.setSize(n14, n10);
            this.topRightCorner.setLocation(n7 - n14, 0);
        } else {
            this.topRightCorner.setVisible(false);
        }
        n2 = this.getMaxScrollTop();
        if (n16 > n2) {
            scrollPane.setScrollTop(n2);
        }
        if (n17 > (n = this.getMaxScrollLeft())) {
            scrollPane.setScrollLeft(n);
        }
        int n18 = Math.max(n7 - n9 - n14, 0);
        this.horizontalScrollBar.setScope(0, n11, Math.min(n11, n18));
        this.horizontalScrollBar.setBlockIncrement(Math.max(1, n18 - this.horizontalReveal));
        int n19 = Math.max(n8 - n10 - n13, 0);
        this.verticalScrollBar.setScope(0, n12, Math.min(n12, n19));
        this.verticalScrollBar.setBlockIncrement(Math.max(1, n19 - this.verticalReveal));
    }

    @Override
    public void setBackgroundPaint(Paint paint) {
        super.setBackgroundPaint(paint);
        this.optimizeScrolling = paint != null && paint.getTransparency() == 1;
    }

    public int getHorizontalIncrement() {
        return this.horizontalScrollBar.getUnitIncrement();
    }

    public void setHorizontalIncrement(int n) {
        this.horizontalScrollBar.setUnitIncrement(n);
    }

    public int getVerticalIncrement() {
        return this.verticalScrollBar.getUnitIncrement();
    }

    public void setVerticalIncrement(int n) {
        this.verticalScrollBar.setUnitIncrement(n);
    }

    public int getHorizontalReveal() {
        return this.horizontalReveal;
    }

    public void setHorizontalReveal(int n) {
        this.horizontalReveal = n;
    }

    public int getVerticalReveal() {
        return this.verticalReveal;
    }

    public void setVerticalReveal(int n) {
        this.verticalReveal = n;
    }

    private boolean isOptimizeScrolling() {
        boolean bl = this.optimizeScrolling;
        if (bl) {
            ScrollPane scrollPane = (ScrollPane)this.getComponent();
            ApplicationContext.DisplayHost displayHost = scrollPane.getDisplay().getDisplayHost();
            ApplicationContext applicationContext = displayHost.getApplicationContext();
            bl = displayHost.getScale() == 1.0 && (applicationContext instanceof DesktopApplicationContext || displayHost.getPeer().canDetermineObscurity() && !displayHost.getPeer().isObscured());
        }
        return bl;
    }

    @Override
    public Bounds getViewportBounds() {
        Component component;
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component component2 = scrollPane.getRowHeader();
        if (component2 != null) {
            int n5 = component2.getWidth();
            n += n5;
            n3 -= n5;
        }
        if ((component = scrollPane.getColumnHeader()) != null) {
            int n6 = component.getHeight();
            n2 += n6;
            n4 -= n6;
        }
        if (this.horizontalScrollBar.isVisible()) {
            n4 -= this.horizontalScrollBar.getHeight();
        }
        if (this.verticalScrollBar.isVisible()) {
            n3 -= this.verticalScrollBar.getWidth();
        }
        return new Bounds(n, n2, n3, n4);
    }

    @Override
    public void horizontalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollPane.ScrollBarPolicy scrollBarPolicy) {
        this.invalidateComponent();
    }

    @Override
    public void verticalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollPane.ScrollBarPolicy scrollBarPolicy) {
        this.invalidateComponent();
    }

    @Override
    public void rowHeaderChanged(ScrollPane scrollPane, Component component) {
        this.invalidateComponent();
    }

    @Override
    public void columnHeaderChanged(ScrollPane scrollPane, Component component) {
        this.invalidateComponent();
    }

    @Override
    public void cornerChanged(ScrollPane scrollPane, Component component) {
        this.invalidateComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollTopChanged(Viewport viewport, int n) {
        ScrollPane scrollPane = (ScrollPane)viewport;
        Component component = scrollPane.getView();
        Component component2 = scrollPane.getRowHeader();
        Component component3 = scrollPane.getColumnHeader();
        int n2 = 0;
        if (component3 != null) {
            n2 = component3.getHeight();
        }
        int n3 = scrollPane.getScrollTop();
        if (component != null && component.isShowing() && this.isOptimizeScrolling()) {
            int n4;
            Bounds bounds = component.getVisibleArea();
            int n5 = bounds.x + component.getX();
            int n6 = bounds.y + component.getY();
            int n7 = bounds.width;
            int n8 = bounds.height;
            if (component2 != null) {
                n4 = component2.getWidth();
                n5 -= n4;
                n7 += n4;
            }
            n4 = n3 - n;
            Graphics2D graphics2D = scrollPane.getGraphics();
            graphics2D.copyArea(n5, n6 += Math.max(n4, 0), n7, n8 -= Math.abs(n4), 0, -n4);
            scrollPane.setConsumeRepaint(true);
            try {
                component.setLocation(component.getX(), n2 - n3);
                if (component2 != null) {
                    component2.setLocation(0, n2 - n3);
                }
            }
            finally {
                scrollPane.setConsumeRepaint(false);
            }
            scrollPane.repaint(n5, n2 + (n4 > 0 ? n8 : 0), n7, Math.abs(n4), true);
        } else {
            if (component != null) {
                component.setLocation(component.getX(), n2 - n3);
            }
            if (component2 != null) {
                component2.setLocation(0, n2 - n3);
            }
        }
        if (n3 >= 0 && n3 <= this.getMaxScrollTop()) {
            this.verticalScrollBar.setValue(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollLeftChanged(Viewport viewport, int n) {
        ScrollPane scrollPane = (ScrollPane)viewport;
        Component component = scrollPane.getView();
        Component component2 = scrollPane.getRowHeader();
        Component component3 = scrollPane.getColumnHeader();
        int n2 = 0;
        if (component2 != null) {
            n2 = component2.getWidth();
        }
        int n3 = scrollPane.getScrollLeft();
        if (component != null && component.isShowing() && this.isOptimizeScrolling()) {
            int n4;
            Bounds bounds = component.getVisibleArea();
            int n5 = bounds.x + component.getX();
            int n6 = bounds.y + component.getY();
            int n7 = bounds.width;
            int n8 = bounds.height;
            if (component3 != null) {
                n4 = component3.getHeight();
                n6 -= n4;
                n8 += n4;
            }
            n4 = n3 - n;
            Graphics2D graphics2D = scrollPane.getGraphics();
            graphics2D.copyArea(n5 += Math.max(n4, 0), n6, n7 -= Math.abs(n4), n8, -n4, 0);
            scrollPane.setConsumeRepaint(true);
            try {
                component.setLocation(n2 - n3, component.getY());
                if (component3 != null) {
                    component3.setLocation(n2 - n3, 0);
                }
            }
            finally {
                scrollPane.setConsumeRepaint(false);
            }
            scrollPane.repaint(n2 + (n4 > 0 ? n7 : 0), n6, Math.abs(n4), n8, true);
        } else {
            if (component != null) {
                component.setLocation(n2 - n3, component.getY());
            }
            if (component3 != null) {
                component3.setLocation(n2 - n3, 0);
            }
        }
        if (n3 >= 0 && n3 <= this.getMaxScrollLeft()) {
            this.horizontalScrollBar.setValue(n3);
        }
    }

    @Override
    public void viewChanged(Viewport viewport, Component component) {
        this.invalidateComponent();
    }

    @Override
    public void valueChanged(ScrollBar scrollBar, int n) {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int n2 = scrollBar.getValue();
        if (scrollBar == this.horizontalScrollBar) {
            scrollPane.setScrollLeft(n2);
        } else {
            scrollPane.setScrollTop(n2);
        }
    }
}

