/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TablePaneAttributeListener;
import org.apache.pivot.wtk.TablePaneListener;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class TablePaneSkin
extends ContainerSkin
implements TablePane.Skin,
TablePaneListener,
TablePaneAttributeListener {
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean showHorizontalGridLines = false;
    private boolean showVerticalGridLines = false;
    private Color horizontalGridColor = Color.BLACK;
    private Color verticalGridColor = Color.BLACK;
    private Color highlightBackgroundColor = Color.GRAY;
    private int[] columnWidths = null;
    private int[] rowHeights = null;

    @Override
    public void install(Component component) {
        super.install(component);
        TablePane tablePane = (TablePane)component;
        tablePane.getTablePaneListeners().add((Object)this);
        tablePane.getTablePaneAttributeListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n6 = rowSequence.getLength();
        int n7 = columnSequence.getLength();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        boolean[] blArray = new boolean[n7];
        int n8 = 0;
        for (n5 = 0; n5 < n7; ++n5) {
            TablePane.Column column = columnSequence.get(n5);
            n4 = column.getWidth();
            n3 = column.isRelative();
            boolean bl = blArray[n5] = n4 < 0;
            if (n3 != 0) {
                nArray2[n5] = n4;
                n8 += n4;
            }
            if (n4 < 0 || n3 != 0) {
                n4 = this.getPreferredColumnWidth(n5);
            }
            nArray[n5] = n4;
        }
        if (n8 > 0) {
            int n9;
            n5 = 0;
            for (n9 = 0; n9 < n7; ++n9) {
                n4 = nArray[n9];
                n3 = nArray2[n9];
                if (n3 <= 0) continue;
                float f = (float)n3 / (float)n8;
                n5 = Math.max(n5, (int)((float)n4 / f));
            }
            for (n9 = 0; n9 < n7; ++n9) {
                n4 = nArray2[n9];
                if (n4 <= 0) continue;
                float f = (float)n4 / (float)n8;
                nArray[n9] = (int)(f * (float)n5);
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            TablePane.Row row = rowSequence.get(n5);
            int n10 = row.getLength();
            for (n4 = 0; n4 < n10 && n4 < n7; ++n4) {
                int n11;
                int n12;
                int n13;
                Component component = row.get(n4);
                if (component == null || !component.isVisible() || (n2 = TablePane.getColumnSpan(component)) <= 1) continue;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                for (n13 = 0; n13 < n2 && n4 + n13 < n7; ++n13) {
                    if (blArray[n4 + n13]) {
                        ++n14;
                    }
                    n15 += nArray2[n4 + n13];
                    n16 += nArray[n4 + n13];
                }
                if (n15 <= 0 && n14 <= 0 || (n12 = component.getPreferredWidth(n13 = row.isRelative() ? -1 : row.getHeight())) <= n16) continue;
                int n17 = n12 - n16;
                if (n15 > 0) {
                    float f = (float)n17 / (float)n15;
                    for (n11 = 0; n11 < n7; ++n11) {
                        int n18 = nArray2[n11];
                        if (n18 <= 0) continue;
                        int n19 = Math.round(f * (float)n18);
                        int n20 = n11;
                        nArray[n20] = nArray[n20] + n19;
                    }
                    continue;
                }
                for (int i = 0; i < n2 && n4 + i < n7; ++i) {
                    if (!blArray[n4 + i]) continue;
                    n11 = n17 / n14;
                    int n21 = n4 + i;
                    nArray[n21] = nArray[n21] + n11;
                    n17 -= n11;
                    --n14;
                }
            }
        }
        boolean[][] blArray2 = this.getOccupiedCells();
        int n22 = 0;
        n4 = this.padding.left + this.padding.right;
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (n2 = 0; n2 < n6; ++n2) {
                if (!blArray2[n2][i]) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n4 += nArray[i];
            ++n22;
        }
        if (n22 > 1) {
            n4 += (n22 - 1) * this.horizontalSpacing;
        }
        return n4;
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n6 = rowSequence.getLength();
        int n7 = columnSequence.getLength();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        boolean[] blArray = new boolean[n6];
        int n8 = 0;
        if (n < 0) {
            n = this.getPreferredWidth(-1);
        }
        int[] nArray3 = this.getColumnWidths(n);
        for (n5 = 0; n5 < n6; ++n5) {
            TablePane.Row row = rowSequence.get(n5);
            n4 = row.getHeight();
            n3 = row.isRelative();
            boolean bl = blArray[n5] = n4 < 0;
            if (n3 != 0) {
                nArray2[n5] = n4;
                n8 += n4;
            }
            if (n4 < 0 || n3 != 0) {
                n4 = this.getPreferredRowHeight(n5, nArray3);
            }
            nArray[n5] = n4;
        }
        if (n8 > 0) {
            int n9;
            n5 = 0;
            for (n9 = 0; n9 < n6; ++n9) {
                n4 = nArray[n9];
                n3 = nArray2[n9];
                if (n3 <= 0) continue;
                float f = (float)n3 / (float)n8;
                n5 = Math.max(n5, (int)((float)n4 / f));
            }
            for (n9 = 0; n9 < n6; ++n9) {
                n4 = nArray2[n9];
                if (n4 <= 0) continue;
                float f = (float)n4 / (float)n8;
                nArray[n9] = (int)(f * (float)n5);
            }
        }
        for (n5 = 0; n5 < n6; ++n5) {
            TablePane.Row row = rowSequence.get(n5);
            int n10 = row.getLength();
            for (n4 = 0; n4 < n10 && n4 < n7; ++n4) {
                int n11;
                int n12;
                Component component = row.get(n4);
                if (component == null || !component.isVisible() || (n2 = TablePane.getRowSpan(component)) <= 1) continue;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                for (n12 = 0; n12 < n2 && n5 + n12 < n6; ++n12) {
                    if (blArray[n5 + n12]) {
                        ++n13;
                    }
                    n14 += nArray2[n5 + n12];
                    n15 += nArray[n5 + n12];
                }
                if (n14 <= 0 && n13 <= 0 || (n12 = component.getPreferredHeight(nArray3[n4])) <= n15) continue;
                int n16 = n12 - n15;
                if (n14 > 0) {
                    float f = (float)n16 / (float)n14;
                    for (n11 = 0; n11 < n6; ++n11) {
                        int n17 = nArray2[n11];
                        if (n17 <= 0) continue;
                        int n18 = Math.round(f * (float)n17);
                        int n19 = n11;
                        nArray[n19] = nArray[n19] + n18;
                    }
                    continue;
                }
                for (int i = 0; i < n2 && n5 + i < n6; ++i) {
                    if (!blArray[n5 + i]) continue;
                    n11 = n16 / n13;
                    int n20 = n5 + i;
                    nArray[n20] = nArray[n20] + n11;
                    n16 -= n11;
                    --n13;
                }
            }
        }
        boolean[][] blArray2 = this.getOccupiedCells();
        int n21 = 0;
        n4 = this.padding.top + this.padding.bottom;
        for (int i = 0; i < n6; ++i) {
            boolean bl = false;
            for (n2 = 0; n2 < n7; ++n2) {
                if (!blArray2[i][n2]) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n4 += nArray[i];
            ++n21;
        }
        if (n21 > 1) {
            n4 += (n21 - 1) * this.verticalSpacing;
        }
        return n4;
    }

    @Override
    public Dimensions getPreferredSize() {
        int n = this.getPreferredWidth(-1);
        int n2 = this.getPreferredHeight(n);
        return new Dimensions(n, n2);
    }

    @Override
    public int getBaseline(int n, int n2) {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n3 = rowSequence.getLength();
        int n4 = columnSequence.getLength();
        int[] nArray = this.getColumnWidths(n);
        int[] nArray2 = this.getRowHeights(n2, nArray);
        boolean[][] blArray = this.getOccupiedCells();
        int n5 = -1;
        int n6 = this.padding.top;
        for (int i = 0; i < n3 && n5 == -1; ++i) {
            TablePane.Row row = rowSequence.get(i);
            boolean bl = false;
            int n7 = row.getLength();
            for (int j = 0; j < n7 && j < n4 && n5 == -1; ++j) {
                Component component = row.get(j);
                if (component != null && component.isVisible()) {
                    int n8;
                    int n9 = Math.min(TablePane.getColumnSpan(component), n4 - j);
                    int n10 = (n9 - 1) * this.horizontalSpacing;
                    for (n8 = 0; n8 < n9 && j + n8 < n4; ++n8) {
                        n10 += nArray[j + n8];
                    }
                    n8 = Math.min(TablePane.getRowSpan(component), n3 - i);
                    int n11 = (n8 - 1) * this.verticalSpacing;
                    for (int k = 0; k < n8 && i + k < n3; ++k) {
                        n11 += nArray2[i + k];
                    }
                    n5 = component.getBaseline(Math.max(n10, 0), Math.max(n11, 0));
                    if (n5 != -1) {
                        n5 += n6;
                    }
                }
                bl |= blArray[i][j];
            }
            if (!bl) continue;
            n6 += nArray2[i] + this.verticalSpacing;
        }
        return n5;
    }

    @Override
    public void layout() {
        int n;
        int n2;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n3 = rowSequence.getLength();
        int n4 = columnSequence.getLength();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        this.columnWidths = this.getColumnWidths(n5);
        this.rowHeights = this.getRowHeights(n6, this.columnWidths);
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n4];
        boolean[][] blArray3 = this.getOccupiedCells();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!blArray3[n2][n]) continue;
                blArray[n2] = true;
                blArray2[n] = true;
            }
        }
        n2 = this.padding.top;
        for (n = 0; n < n3; ++n) {
            TablePane.Row row = rowSequence.get(n);
            int n7 = this.padding.left;
            int n8 = row.getLength();
            for (int i = 0; i < n8 && i < n4; ++i) {
                Component component = row.get(i);
                if (component != null && component.isVisible()) {
                    int n9;
                    component.setLocation(n7, n2);
                    int n10 = TablePane.getColumnSpan(component);
                    n10 = Math.min(n10, n4 - i);
                    int n11 = (n10 - 1) * this.horizontalSpacing;
                    for (n9 = 0; n9 < n10 && i + n9 < n4; ++n9) {
                        n11 += this.columnWidths[i + n9];
                    }
                    n9 = TablePane.getRowSpan(component);
                    n9 = Math.min(n9, n3 - n);
                    int n12 = (n9 - 1) * this.verticalSpacing;
                    for (int j = 0; j < n9 && n + j < n3; ++j) {
                        n12 += this.rowHeights[n + j];
                    }
                    component.setSize(Math.max(n11, 0), Math.max(n12, 0));
                }
                if (!blArray2[i]) continue;
                n7 += this.columnWidths[i] + this.horizontalSpacing;
            }
            if (!blArray[n]) continue;
            n2 += this.rowHeights[n] + this.verticalSpacing;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Object object;
        int n;
        super.paint(graphics2D);
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n2 = rowSequence.getLength();
        int n3 = columnSequence.getLength();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        graphics2D.setPaint(this.highlightBackgroundColor);
        int n6 = this.padding.top;
        for (n = 0; n < n2; ++n) {
            object = rowSequence.get(n);
            if (((TablePane.Row)object).isHighlighted()) {
                graphics2D.fillRect(0, n6, n4, this.rowHeights[n]);
            }
            n6 += this.rowHeights[n] + this.verticalSpacing;
        }
        n6 = this.padding.left;
        for (n = 0; n < n3; ++n) {
            object = columnSequence.get(n);
            if (((TablePane.Column)object).isHighlighted()) {
                graphics2D.fillRect(n6, 0, this.columnWidths[n], n5);
            }
            n6 += this.columnWidths[n] + this.horizontalSpacing;
        }
        if (this.showHorizontalGridLines && this.verticalSpacing > 0 || this.showVerticalGridLines && this.horizontalSpacing > 0) {
            int n7;
            int n8;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setStroke(new BasicStroke());
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area area = null;
            int n9 = this.padding.top;
            for (n8 = 0; n8 < n2; ++n8) {
                int n10 = this.padding.left;
                for (n7 = 0; n7 < n3; ++n7) {
                    Component component = tablePane.getCellComponent(n8, n7);
                    if (component != null) {
                        int n11 = TablePane.getRowSpan(component);
                        int n12 = TablePane.getColumnSpan(component);
                        if (n11 > 1 || n12 > 1) {
                            int n13;
                            int n14 = n9;
                            int n15 = n10;
                            int n16 = this.rowHeights[n8];
                            int n17 = this.columnWidths[n7];
                            for (n13 = n8 + 1; n13 < n8 + n11 && n13 < n2; ++n13) {
                                n16 += this.rowHeights[n13] + this.verticalSpacing;
                            }
                            for (n13 = n7 + 1; n13 < n7 + n12 && n13 < n3; ++n13) {
                                n17 += this.columnWidths[n13] + this.horizontalSpacing;
                            }
                            if (area == null) {
                                area = new Area(graphics2D.getClip());
                            }
                            if (this.horizontalSpacing > 1) {
                                n17 += this.horizontalSpacing - 1;
                                n15 -= (int)((float)this.horizontalSpacing * 0.5f - 0.5f);
                            }
                            if (this.verticalSpacing > 1) {
                                n16 += this.verticalSpacing - 1;
                                n14 -= (int)((float)this.verticalSpacing * 0.5f - 0.5f);
                            }
                            Rectangle2D.Float float_ = new Rectangle2D.Float(n15, n14, n17, n16);
                            area.subtract(new Area(float_));
                        }
                    }
                    n10 += this.columnWidths[n7] + this.horizontalSpacing;
                }
                n9 += this.rowHeights[n8] + this.verticalSpacing;
            }
            if (area != null) {
                graphics2D2.clip(area);
            }
            if (this.showHorizontalGridLines && this.verticalSpacing > 0 && n2 > 1) {
                graphics2D2.setPaint(this.horizontalGridColor);
                n8 = this.padding.top + (this.rowHeights[0] + this.verticalSpacing);
                for (n9 = 1; n9 < n2; ++n9) {
                    n7 = Math.max(n8 - (int)Math.ceil((float)this.verticalSpacing * 0.5f), 0);
                    GraphicsUtilities.drawLine(graphics2D2, 0, n7, n4, Orientation.HORIZONTAL);
                    n8 += this.rowHeights[n9] + this.verticalSpacing;
                }
            }
            if (this.showVerticalGridLines && this.horizontalSpacing > 0 && n3 > 1) {
                graphics2D2.setPaint(this.verticalGridColor);
                n8 = this.padding.left + (this.columnWidths[0] + this.horizontalSpacing);
                for (n9 = 1; n9 < n3; ++n9) {
                    n7 = Math.max(n8 - (int)Math.ceil((double)this.horizontalSpacing * 0.5), 0);
                    GraphicsUtilities.drawLine(graphics2D2, n7, 0, n5, Orientation.VERTICAL);
                    n8 += this.columnWidths[n9] + this.horizontalSpacing;
                }
            }
            graphics2D2.dispose();
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(string));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative");
        }
        this.horizontalSpacing = n;
        this.invalidateComponent();
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative");
        }
        this.verticalSpacing = n;
        this.invalidateComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean bl) {
        this.showHorizontalGridLines = bl;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean bl) {
        this.showVerticalGridLines = bl;
        this.repaintComponent();
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = color;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setHorizontalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = color;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setVerticalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor(string));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor(string));
    }

    private boolean[][] getOccupiedCells() {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n = rowSequence.getLength();
        int n2 = columnSequence.getLength();
        boolean[][] blArray = new boolean[n][n2];
        for (int i = 0; i < n; ++i) {
            TablePane.Row row = rowSequence.get(i);
            int n3 = row.getLength();
            for (int j = 0; j < n3 && j < n2; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible()) continue;
                int n4 = TablePane.getRowSpan(component);
                int n5 = TablePane.getColumnSpan(component);
                for (int k = 0; k < n4 && i + k < n; ++k) {
                    for (int i2 = 0; i2 < n5 && j + i2 < n2; ++i2) {
                        blArray[i + k][j + i2] = true;
                    }
                }
            }
        }
        return blArray;
    }

    private int getPreferredColumnWidth(int n) {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        int n2 = 0;
        int n3 = rowSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Component component;
            TablePane.Row row = rowSequence.get(i);
            if (row.getLength() <= n || (component = row.get(n)) == null || !component.isVisible() || TablePane.getColumnSpan(component) != 1) continue;
            n2 = Math.max(n2, component.getPreferredWidth(-1));
        }
        return n2;
    }

    private boolean isColumnVisible(int n) {
        boolean bl = false;
        boolean[][] blArray = this.getOccupiedCells();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i][n]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int getPreferredRowHeight(int n, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("columnWidths is null");
        }
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        TablePane.Row row = tablePane.getRows().get(n);
        int n2 = 0;
        int n3 = row.getLength();
        int n4 = columnSequence.getLength();
        for (int i = 0; i < n3 && i < n4; ++i) {
            Component component = row.get(i);
            if (component == null || !component.isVisible() || TablePane.getRowSpan(component) != 1) continue;
            n2 = Math.max(n2, component.getPreferredHeight(nArray[i]));
        }
        return n2;
    }

    private boolean isRowVisible(int n) {
        boolean bl = false;
        boolean[][] blArray = this.getOccupiedCells();
        for (int i = 0; i < blArray[n].length; ++i) {
            if (!blArray[n][i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int[] getColumnWidths(int n) {
        int n2;
        Object object;
        int n3;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        TablePane.ColumnSequence columnSequence = tablePane.getColumns();
        int n4 = rowSequence.getLength();
        int n5 = columnSequence.getLength();
        int[] nArray = new int[n5];
        boolean[] blArray = new boolean[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = this.padding.left + this.padding.right;
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.isColumnVisible(n3)) {
                object = columnSequence.get(n3);
                n2 = ((TablePane.Column)object).getWidth();
                if (((TablePane.Column)object).isRelative()) {
                    nArray[n3] = -n2;
                    n6 += n2;
                } else {
                    if (n2 < 0) {
                        n2 = this.getPreferredColumnWidth(n3);
                        blArray[n3] = true;
                    }
                    nArray[n3] = n2;
                    n8 += n2;
                }
                ++n7;
                continue;
            }
            nArray[n3] = 0;
        }
        if (n7 > 1) {
            n8 += (n7 - 1) * this.horizontalSpacing;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            object = rowSequence.get(n3);
            int n9 = ((TablePane.Row)object).getLength();
            for (n2 = 0; n2 < n9 && n2 < n5; ++n2) {
                int n10;
                int n11;
                Component component = ((TablePane.Row)object).get(n2);
                if (component == null || !component.isVisible() || (n11 = TablePane.getColumnSpan(component)) <= 1) continue;
                boolean bl = true;
                int n12 = 0;
                int n13 = 0;
                for (n10 = 0; n10 < n11 && n2 + n10 < n5; ++n10) {
                    if (nArray[n2 + n10] < 0) {
                        bl = false;
                        break;
                    }
                    if (blArray[n2 + n10]) {
                        ++n12;
                    }
                    n13 += nArray[n2 + n10];
                }
                if (!bl || n12 <= 0 || (n10 = component.getPreferredWidth(-1)) <= n13) continue;
                int n14 = n10 - n13;
                for (int i = 0; i < n11 && n2 + i < n5; ++i) {
                    if (!blArray[n2 + i]) continue;
                    int n15 = n14 / n12;
                    int n16 = n2 + i;
                    nArray[n16] = nArray[n16] + n15;
                    n8 += n15;
                    n14 -= n15;
                    --n12;
                }
            }
        }
        n3 = Math.max(n - n8, 0);
        if (n6 > 0 && n3 > 0) {
            for (int i = 0; i < n5; ++i) {
                int n17;
                if (nArray[i] >= 0) continue;
                n2 = -nArray[i];
                float f = (float)n2 / (float)n6;
                nArray[i] = n17 = (int)((float)n3 * f);
                n3 -= n17;
                n6 -= n2;
            }
        }
        return nArray;
    }

    private int[] getRowHeights(int n, int[] nArray) {
        int n2;
        TablePane.Row row;
        int n3;
        if (nArray == null) {
            throw new IllegalArgumentException("columnWidths is null");
        }
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rowSequence = tablePane.getRows();
        int n4 = tablePane.getRows().getLength();
        int n5 = tablePane.getColumns().getLength();
        int[] nArray2 = new int[n4];
        boolean[] blArray = new boolean[n4];
        int n6 = 0;
        int n7 = 0;
        int n8 = this.padding.top + this.padding.bottom;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.isRowVisible(n3)) {
                row = rowSequence.get(n3);
                n2 = row.getHeight();
                if (row.isRelative()) {
                    nArray2[n3] = -n2;
                    n6 += n2;
                } else {
                    if (n2 < 0) {
                        n2 = this.getPreferredRowHeight(n3, nArray);
                        blArray[n3] = true;
                    }
                    nArray2[n3] = n2;
                    n8 += n2;
                }
                ++n7;
                continue;
            }
            nArray2[n3] = 0;
        }
        if (n7 > 1) {
            n8 += (n7 - 1) * this.verticalSpacing;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            row = rowSequence.get(n3);
            int n9 = row.getLength();
            for (n2 = 0; n2 < n9 && n2 < n5; ++n2) {
                int n10;
                int n11;
                Component component = row.get(n2);
                if (component == null || !component.isVisible() || (n11 = TablePane.getRowSpan(component)) <= 1) continue;
                boolean bl = true;
                int n12 = 0;
                int n13 = 0;
                for (n10 = 0; n10 < n11 && n3 + n10 < n4; ++n10) {
                    if (nArray2[n3 + n10] < 0) {
                        bl = false;
                        break;
                    }
                    if (blArray[n3 + n10]) {
                        ++n12;
                    }
                    n13 += nArray2[n3 + n10];
                }
                if (!bl || n12 <= 0 || (n10 = component.getPreferredHeight(nArray[n2])) <= n13) continue;
                int n14 = n10 - n13;
                for (int i = 0; i < n11 && n3 + i < n4; ++i) {
                    if (!blArray[n3 + i]) continue;
                    int n15 = n14 / n12;
                    int n16 = n3 + i;
                    nArray2[n16] = nArray2[n16] + n15;
                    n8 += n15;
                    n14 -= n15;
                    --n12;
                }
            }
        }
        n3 = Math.max(n - n8, 0);
        if (n6 > 0 && n3 > 0) {
            for (int i = 0; i < n4; ++i) {
                int n17;
                if (nArray2[i] >= 0) continue;
                n2 = -nArray2[i];
                float f = (float)n2 / (float)n6;
                nArray2[i] = n17 = (int)((float)n3 * f);
                n3 -= n17;
                n6 -= n2;
            }
        }
        return nArray2;
    }

    @Override
    public int getRowAt(int n) {
        int n2;
        if (this.rowHeights == null) {
            return -1;
        }
        int n3 = -1;
        int n4 = 0;
        for (int i = this.padding.top; i <= n && n4 < this.rowHeights.length; i += n2 + this.verticalSpacing, ++n4) {
            n2 = this.rowHeights[n4];
            if (n >= i + n2) continue;
            n3 = n4;
            break;
        }
        return n3;
    }

    @Override
    public Bounds getRowBounds(int n) {
        if (this.rowHeights == null) {
            return new Bounds(0, 0, 0, 0);
        }
        if (n < 0 || n >= this.rowHeights.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = this.padding.top;
        for (int i = 0; i < n; ++i) {
            n2 += this.rowHeights[i] + this.verticalSpacing;
        }
        return new Bounds(0, n2, this.getWidth(), this.rowHeights[n]);
    }

    @Override
    public int getColumnAt(int n) {
        int n2;
        if (this.columnWidths == null) {
            return -1;
        }
        int n3 = -1;
        int n4 = 0;
        for (int i = this.padding.left; i <= n && n4 < this.columnWidths.length; i += n2 + this.horizontalSpacing, ++n4) {
            n2 = this.columnWidths[n4];
            if (n >= i + n2) continue;
            n3 = n4;
            break;
        }
        return n3;
    }

    @Override
    public Bounds getColumnBounds(int n) {
        if (this.columnWidths == null) {
            return new Bounds(0, 0, 0, 0);
        }
        if (n < 0 || n >= this.columnWidths.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = this.padding.left;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnWidths[i] + this.horizontalSpacing;
        }
        return new Bounds(n2, 0, this.columnWidths[n], this.getHeight());
    }

    @Override
    public void rowInserted(TablePane tablePane, int n) {
        this.invalidateComponent();
    }

    @Override
    public void rowsRemoved(TablePane tablePane, int n, Sequence<TablePane.Row> sequence) {
        this.invalidateComponent();
    }

    @Override
    public void rowHeightChanged(TablePane.Row row, int n, boolean bl) {
        this.invalidateComponent();
    }

    @Override
    public void rowHighlightedChanged(TablePane.Row row) {
        TablePane tablePane = row.getTablePane();
        this.repaintComponent(this.getRowBounds(tablePane.getRows().indexOf(row)));
    }

    @Override
    public void columnInserted(TablePane tablePane, int n) {
        this.invalidateComponent();
    }

    @Override
    public void columnsRemoved(TablePane tablePane, int n, Sequence<TablePane.Column> sequence) {
        this.invalidateComponent();
    }

    @Override
    public void columnWidthChanged(TablePane.Column column, int n, boolean bl) {
        this.invalidateComponent();
    }

    @Override
    public void columnHighlightedChanged(TablePane.Column column) {
        TablePane tablePane = column.getTablePane();
        this.repaintComponent(this.getColumnBounds(tablePane.getColumns().indexOf(column)));
    }

    @Override
    public void cellInserted(TablePane.Row row, int n) {
        this.invalidateComponent();
    }

    @Override
    public void cellsRemoved(TablePane.Row row, int n, Sequence<Component> sequence) {
        this.invalidateComponent();
    }

    @Override
    public void cellUpdated(TablePane.Row row, int n, Component component) {
        this.invalidateComponent();
    }

    @Override
    public void rowSpanChanged(TablePane tablePane, Component component, int n) {
        this.invalidateComponent();
    }

    @Override
    public void columnSpanChanged(TablePane tablePane, Component component, int n) {
        this.invalidateComponent();
    }
}

