/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.text.CharacterIterator;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.TextNodeListener;

public final class TextNode
extends Node {
    private StringBuilder textBuilder;
    private TextNodeListenerList textNodeListeners = new TextNodeListenerList();

    public TextNode() {
        this("");
    }

    public TextNode(TextNode textNode) {
        this(textNode.getText());
    }

    public TextNode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text is null.");
        }
        this.textBuilder = new StringBuilder(string);
    }

    public void insertText(char c, int n) {
        this.insertText(Character.toString(c), n);
    }

    public void insertText(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (n < 0 || n > this.textBuilder.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = string.length();
        if (n2 > 0) {
            this.textBuilder.insert(n, string);
            this.rangeInserted(n, n2);
            this.textNodeListeners.charactersInserted(this, n, n2);
        }
    }

    public String removeText(int n, int n2) {
        String string;
        if (n < 0 || n + n2 > this.textBuilder.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            string = "";
        } else {
            int n3 = n;
            int n4 = n + n2;
            string = this.textBuilder.substring(n3, n4);
            this.textBuilder.delete(n3, n4);
            this.textNodeListeners.charactersRemoved(this, n, string);
            this.rangeRemoved(n, n2);
        }
        return string;
    }

    @Override
    public char getCharacterAt(int n) {
        if (n < 0 || n >= this.textBuilder.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.textBuilder.charAt(n);
    }

    @Override
    public int getCharacterCount() {
        return this.textBuilder.length();
    }

    public CharacterIterator getCharacterIterator() {
        return this.getCharacterIterator(0, this.getCharacterCount());
    }

    public CharacterIterator getCharacterIterator(int n) {
        return this.getCharacterIterator(n, this.getCharacterCount());
    }

    public CharacterIterator getCharacterIterator(int n, int n2) {
        return new TextNodeCharacterIterator(n, n2);
    }

    public String getText() {
        return this.textBuilder.toString();
    }

    public void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text is null.");
        }
        this.removeText(0, this.getCharacterCount());
        this.insertText(string, 0);
    }

    @Override
    public void insertRange(Node node, int n) {
        if (!(node instanceof TextNode)) {
            throw new IllegalArgumentException("range is not a text node.");
        }
        TextNode textNode = (TextNode)node;
        this.insertText(textNode.getText(), n);
    }

    @Override
    public Node removeRange(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        String string = this.removeText(n, n2);
        TextNode textNode = new TextNode(string);
        return textNode;
    }

    @Override
    public Node getRange(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (n < 0 || n + n2 > this.textBuilder.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        int n4 = n + n2;
        String string = this.textBuilder.substring(n3, n4);
        TextNode textNode = new TextNode(string);
        return textNode;
    }

    @Override
    public Node duplicate(boolean bl) {
        return new TextNode(this);
    }

    public String toString() {
        return this.getText();
    }

    public ListenerList<TextNodeListener> getTextNodeListeners() {
        return this.textNodeListeners;
    }

    private static class TextNodeListenerList
    extends ListenerList<TextNodeListener>
    implements TextNodeListener {
        private TextNodeListenerList() {
        }

        @Override
        public void charactersInserted(TextNode textNode, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextNodeListener textNodeListener = (TextNodeListener)iterator.next();
                textNodeListener.charactersInserted(textNode, n, n2);
            }
        }

        @Override
        public void charactersRemoved(TextNode textNode, int n, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextNodeListener textNodeListener = (TextNodeListener)iterator.next();
                textNodeListener.charactersRemoved(textNode, n, string);
            }
        }
    }

    private class TextNodeCharacterIterator
    implements CharacterIterator {
        private final int beginIndex;
        private final int endIndex;
        private int index;

        public TextNodeCharacterIterator(int n, int n2) {
            this.beginIndex = n;
            this.endIndex = n2;
            this.index = 0;
        }

        public TextNodeCharacterIterator(TextNodeCharacterIterator textNodeCharacterIterator) {
            this.beginIndex = textNodeCharacterIterator.beginIndex;
            this.endIndex = textNodeCharacterIterator.endIndex;
            this.index = textNodeCharacterIterator.index;
        }

        @Override
        public char first() {
            return this.setIndex(this.beginIndex);
        }

        @Override
        public char last() {
            return this.setIndex(TextNode.this.getCharacterCount() == 0 ? this.endIndex : this.endIndex - 1);
        }

        @Override
        public char next() {
            return this.setIndex(this.index < this.endIndex ? this.index + 1 : 65535);
        }

        @Override
        public char previous() {
            return this.setIndex(this.index > this.beginIndex ? this.index - 1 : 65535);
        }

        @Override
        public char current() {
            return this.index < this.endIndex ? TextNode.this.getCharacterAt(this.index) : (char)'\uffff';
        }

        @Override
        public int getBeginIndex() {
            return this.beginIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public char setIndex(int n) {
            if (n < this.beginIndex || n > this.endIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.index = n;
            return this.current();
        }

        @Override
        public Object clone() {
            return new TextNodeCharacterIterator(this);
        }
    }
}

