/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text.validation;

import java.util.Locale;
import org.apache.pivot.wtk.text.validation.FloatValidator;

public class FloatRangeValidator
extends FloatValidator {
    private float minValue;
    private float maxValue;

    public FloatRangeValidator() {
        this.minValue = 0.0f;
        this.maxValue = 1.0f;
    }

    public FloatRangeValidator(Locale locale) {
        super(locale);
        this.minValue = 0.0f;
        this.maxValue = 1.0f;
    }

    public FloatRangeValidator(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
    }

    public FloatRangeValidator(Locale locale, float f, float f2) {
        super(locale);
        this.minValue = f;
        this.maxValue = f2;
    }

    public float getMinimum() {
        return this.minValue;
    }

    public void setMinimum(float f) {
        this.minValue = f;
    }

    public float getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(float f) {
        this.maxValue = f;
    }

    @Override
    public boolean isValid(String string) {
        boolean bl = false;
        if (super.isValid(string)) {
            float f = this.textToObject(string).floatValue();
            bl = f >= this.minValue && f <= this.maxValue;
        }
        return bl;
    }

    private final Float textToObject(String string) {
        return Float.valueOf(this.parseNumber(string).floatValue());
    }
}

