/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.tools.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.io.FileList;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DropAction;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.TreeBranch;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.OverlayDecorator;
import org.apache.pivot.wtkx.WTKX;
import org.apache.pivot.wtkx.WTKXSerializer;

public class JSONViewer
implements Application {
    private Window window = null;
    @WTKX
    private TreeView treeView = null;
    private OverlayDecorator promptDecorator = new OverlayDecorator();
    public static final String APPLICATION_KEY = "application";
    public static final String WINDOW_TITLE = "JSON Viewer";

    public void startup(Display display, Map<String, String> map) throws Exception {
        WTKXSerializer wTKXSerializer = new WTKXSerializer();
        wTKXSerializer.put(APPLICATION_KEY, (Object)this);
        this.window = (Window)wTKXSerializer.readObject((Object)this, "json_viewer.wtkx");
        wTKXSerializer.bind((Object)this);
        Label label = new Label("Drag or paste JSON here");
        label.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
        label.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.promptDecorator.setOverlay((Component)label);
        this.treeView.getDecorators().add((Decorator)this.promptDecorator);
        this.window.setTitle(WINDOW_TITLE);
        this.window.open(display);
        this.window.requestFocus();
    }

    public boolean shutdown(boolean bl) {
        if (this.window != null) {
            this.window.close();
        }
        return false;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void paste() {
        Manifest manifest = Clipboard.getContent();
        if (manifest != null && manifest.containsText()) {
            String string = null;
            JSONSerializer jSONSerializer = new JSONSerializer();
            try {
                string = manifest.getText();
                this.setValue(jSONSerializer.readObject((Reader)new StringReader(string)));
            }
            catch (Exception exception) {
                Prompt.prompt((String)exception.getMessage(), (Window)this.window);
            }
            this.window.setTitle(WINDOW_TITLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropAction drop(Manifest manifest) {
        DropAction dropAction;
        block10: {
            dropAction = null;
            try {
                FileList fileList = manifest.getFileList();
                if (fileList.getLength() == 1) {
                    File file = (File)fileList.get(0);
                    JSONSerializer jSONSerializer = new JSONSerializer();
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                            this.setValue(jSONSerializer.readObject((InputStream)fileInputStream));
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        Prompt.prompt((String)exception.getMessage(), (Window)this.window);
                    }
                    this.window.setTitle("JSON Viewer - " + file.getName());
                    dropAction = DropAction.COPY;
                    break block10;
                }
                Prompt.prompt((String)"Multiple files not supported.", (Window)this.window);
            }
            catch (IOException iOException) {
                Prompt.prompt((String)iOException.getMessage(), (Window)this.window);
            }
        }
        return dropAction;
    }

    private void setValue(Object object) {
        assert (object instanceof Map || object instanceof List);
        if (this.promptDecorator != null) {
            this.treeView.getDecorators().remove((Decorator)this.promptDecorator);
            this.promptDecorator = null;
        }
        TreeBranch treeBranch = new TreeBranch();
        treeBranch.add(JSONViewer.build(object));
        this.treeView.setTreeData((List)treeBranch);
        this.treeView.expandBranch(new Sequence.Tree.Path(new Integer[]{0}));
    }

    private static TreeNode build(Object object) {
        TreeNode treeNode;
        if (object instanceof Map) {
            TreeBranch treeBranch = new TreeBranch("{}");
            Map map = (Map)object;
            for (String string : map) {
                TreeNode treeNode2 = JSONViewer.build(map.get((Object)string));
                String string2 = treeNode2.getText();
                if (string2 == null) {
                    treeNode2.setText(string);
                } else {
                    treeNode2.setText(string + " : " + string2);
                }
                treeBranch.add(treeNode2);
            }
            treeNode = treeBranch;
        } else if (object instanceof List) {
            TreeBranch treeBranch = new TreeBranch("[]");
            List list = (List)object;
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode3 = JSONViewer.build(list.get(i));
                String string = treeNode3.getText();
                if (string == null) {
                    treeNode3.setText("[" + i + "]");
                } else {
                    treeNode3.setText("[" + i + "] " + string);
                }
                treeBranch.add(treeNode3);
            }
            treeNode = treeBranch;
        } else {
            treeNode = object instanceof String ? new TreeNode("\"" + object.toString() + "\"") : (object instanceof Number ? new TreeNode(object.toString()) : (object instanceof Boolean ? new TreeNode(object.toString()) : new TreeNode("null")));
        }
        return treeNode;
    }

    public static void main(String[] stringArray) {
        DesktopApplicationContext.main(JSONViewer.class, (String[])stringArray);
    }
}

