/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.tools.wtk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.apache.pivot.collections.Group;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.tools.wtk.EventLoggerListener;
import org.apache.pivot.tools.wtk.EventLoggerSkin;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;

public class EventLogger
extends Container {
    private Component source = null;
    private HashMap<Class<?>, Object> eventListenerProxies = new HashMap();
    private LoggerInvocationHandler loggerInvocationHandler = new LoggerInvocationHandler();
    private HashSet<Method> declaredEvents = new HashSet();
    private DeclaredEventGroup declaredEventGroup = new DeclaredEventGroup();
    private HashSet<Method> includeEvents = new HashSet();
    private IncludeEventGroup includeEventGroup = new IncludeEventGroup();
    private EventLoggerListenerList eventLoggerListeners = new EventLoggerListenerList();

    public EventLogger() {
        this(null);
    }

    public EventLogger(Component component) {
        this.setSource(component);
        this.setSkin((org.apache.pivot.wtk.Skin)new EventLoggerSkin());
    }

    public Component getSource() {
        return this.source;
    }

    public void setSource(Component component) {
        Component component2 = this.source;
        if (component != component2) {
            if (component2 != null) {
                this.unregisterEventListeners();
            }
            this.source = component;
            this.declaredEvents.clear();
            this.includeEvents.clear();
            if (component != null) {
                this.registerEventListeners();
            }
            this.eventLoggerListeners.sourceChanged(this, component2);
        }
    }

    public DeclaredEventGroup getDeclaredEvents() {
        return this.declaredEventGroup;
    }

    public IncludeEventGroup getIncludeEvents() {
        return this.includeEventGroup;
    }

    public void clearLog() {
        Skin skin = (Skin)this.getSkin();
        skin.clearLog();
    }

    private void registerEventListeners() {
        Method[] methodArray = this.source.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method;
            Object object;
            Object object2;
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Method method2 = methodArray[i];
            if (!ListenerList.class.isAssignableFrom(method2.getReturnType()) || (method2.getModifiers() & 8) != 0 || (typeArray = (parameterizedType = (ParameterizedType)method2.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class clazz = (Class)typeArray[0];
            if (!clazz.isInterface()) {
                throw new RuntimeException(clazz.getName() + " is not an interface.");
            }
            Method[] methodArray2 = clazz.getMethods();
            for (int j = 0; j < methodArray2.length; ++j) {
                object2 = methodArray2[j];
                this.declaredEvents.add(object2);
            }
            try {
                object = method2.invoke((Object)this.source, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            object2 = this.eventListenerProxies.get((Object)clazz);
            if (object2 == null) {
                object2 = Proxy.newProxyInstance(ThreadUtilities.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.loggerInvocationHandler);
                this.eventListenerProxies.put((Object)clazz, object2);
            }
            Class<?> clazz2 = object.getClass();
            try {
                method = clazz2.getMethod("add", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            try {
                method.invoke(object, object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    private void unregisterEventListeners() {
        Method[] methodArray = this.source.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method;
            Object object;
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Method method2 = methodArray[i];
            if (!ListenerList.class.isAssignableFrom(method2.getReturnType()) || (method2.getModifiers() & 8) != 0 || (typeArray = (parameterizedType = (ParameterizedType)method2.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class clazz = (Class)typeArray[0];
            try {
                object = method2.invoke((Object)this.source, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            Object object2 = this.eventListenerProxies.get((Object)clazz);
            Class<?> clazz2 = object.getClass();
            try {
                method = clazz2.getMethod("remove", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            try {
                method.invoke(object, object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    public ListenerList<EventLoggerListener> getEventLoggerListeners() {
        return this.eventLoggerListeners;
    }

    private static class EventLoggerListenerList
    extends ListenerList<EventLoggerListener>
    implements EventLoggerListener {
        private EventLoggerListenerList() {
        }

        @Override
        public void sourceChanged(EventLogger eventLogger, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                EventLoggerListener eventLoggerListener = (EventLoggerListener)iterator.next();
                eventLoggerListener.sourceChanged(eventLogger, component);
            }
        }

        @Override
        public void eventIncluded(EventLogger eventLogger, Method method) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                EventLoggerListener eventLoggerListener = (EventLoggerListener)iterator.next();
                eventLoggerListener.eventIncluded(eventLogger, method);
            }
        }

        @Override
        public void eventExcluded(EventLogger eventLogger, Method method) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                EventLoggerListener eventLoggerListener = (EventLoggerListener)iterator.next();
                eventLoggerListener.eventExcluded(eventLogger, method);
            }
        }

        @Override
        public void eventFired(EventLogger eventLogger, Method method, Object[] objectArray) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                EventLoggerListener eventLoggerListener = (EventLoggerListener)iterator.next();
                eventLoggerListener.eventFired(eventLogger, method, objectArray);
            }
        }
    }

    private class LoggerInvocationHandler
    implements InvocationHandler {
        private LoggerInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (EventLogger.this.includeEvents.contains((Object)method)) {
                EventLogger.this.eventLoggerListeners.eventFired(EventLogger.this, method, objectArray);
            }
            Object object2 = null;
            Class<?> clazz = method.getReturnType();
            if (clazz == Vote.class) {
                object2 = Vote.APPROVE;
            } else if (clazz == Boolean.TYPE) {
                object2 = false;
            }
            return object2;
        }
    }

    public final class IncludeEventGroup
    implements Group<Method>,
    Iterable<Method> {
        private IncludeEventGroup() {
        }

        public boolean add(Method method) {
            boolean bl = false;
            if (!EventLogger.this.declaredEvents.contains((Object)method)) {
                throw new IllegalArgumentException("Event has not been declared.");
            }
            if (!EventLogger.this.includeEvents.contains((Object)method)) {
                EventLogger.this.includeEvents.add((Object)method);
                EventLogger.this.eventLoggerListeners.eventIncluded(EventLogger.this, method);
                bl = true;
            }
            return bl;
        }

        public boolean remove(Method method) {
            boolean bl = false;
            if (EventLogger.this.includeEvents.contains((Object)method)) {
                EventLogger.this.includeEvents.remove((Object)method);
                EventLogger.this.eventLoggerListeners.eventExcluded(EventLogger.this, method);
                bl = true;
            }
            return bl;
        }

        public boolean contains(Method method) {
            return EventLogger.this.includeEvents.contains((Object)method);
        }

        @Override
        public Iterator<Method> iterator() {
            return new ImmutableIterator(EventLogger.this.includeEvents.iterator());
        }
    }

    public final class DeclaredEventGroup
    implements Group<Method>,
    Iterable<Method> {
        private DeclaredEventGroup() {
        }

        public boolean add(Method method) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Method method) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Method method) {
            return EventLogger.this.declaredEvents.contains((Object)method);
        }

        @Override
        public Iterator<Method> iterator() {
            return new ImmutableIterator(EventLogger.this.declaredEvents.iterator());
        }
    }

    public static interface Skin {
        public void clearLog();
    }
}

