/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.tools.wtk;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.tools.wtk.EventLogger;
import org.apache.pivot.tools.wtk.EventLoggerListener;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.TreeViewNodeStateListener;
import org.apache.pivot.wtk.content.TreeBranch;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtkx.WTKXSerializer;

class EventLoggerSkin
extends ContainerSkin
implements EventLogger.Skin,
EventLoggerListener {
    private Component content = null;
    private TreeView declaredEventsTreeView = null;
    private TableView firedEventsTableView = null;
    private boolean updating = false;
    private static TreeNodeComparator treeNodeComparator = new TreeNodeComparator();

    EventLoggerSkin() {
    }

    public void install(Component component) {
        Resources resources;
        super.install(component);
        EventLogger eventLogger = (EventLogger)component;
        eventLogger.getEventLoggerListeners().add((Object)this);
        try {
            resources = new Resources(this.getClass().getName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        WTKXSerializer wTKXSerializer = new WTKXSerializer(resources);
        try {
            this.content = (Component)wTKXSerializer.readObject((Object)this, "event_logger_skin.wtkx");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        eventLogger.add(this.content);
        this.declaredEventsTreeView = (TreeView)wTKXSerializer.getValue("declaredEventsTreeView");
        this.firedEventsTableView = (TableView)wTKXSerializer.getValue("firedEventsTableView");
        this.declaredEventsTreeView.getTreeViewNodeStateListeners().add((Object)new TreeViewNodeStateListener(){

            public void nodeCheckStateChanged(TreeView treeView, Sequence.Tree.Path path, TreeView.NodeCheckState nodeCheckState) {
                TreeView.NodeCheckState nodeCheckState2 = treeView.getNodeCheckState(path);
                if (!EventLoggerSkin.this.updating) {
                    EventLoggerSkin.this.updating = true;
                    ApplicationContext.queueCallback((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EventLoggerSkin.this.updating = false;
                        }
                    });
                    EventLogger eventLogger = (EventLogger)EventLoggerSkin.this.getComponent();
                    boolean bl = nodeCheckState2 == TreeView.NodeCheckState.CHECKED;
                    List list = treeView.getTreeData();
                    TreeNode treeNode = (TreeNode)Sequence.Tree.get((Sequence)list, (Sequence.Tree.Path)path);
                    if (treeNode instanceof List) {
                        if (nodeCheckState == TreeView.NodeCheckState.CHECKED || nodeCheckState2 == TreeView.NodeCheckState.CHECKED) {
                            List list2 = (List)treeNode;
                            Sequence.Tree.Path path2 = new Sequence.Tree.Path(path);
                            int n = path2.getLength();
                            path2.add(Integer.valueOf(0));
                            int n2 = list2.getLength();
                            for (int i = 0; i < n2; ++i) {
                                path2.update(n, Integer.valueOf(i));
                                treeView.setNodeChecked(path2, bl);
                                EventNode eventNode = (EventNode)((Object)list2.get(i));
                                Method method = eventNode.getEvent();
                                if (bl) {
                                    eventLogger.getIncludeEvents().add(method);
                                    continue;
                                }
                                eventLogger.getIncludeEvents().remove(method);
                            }
                        }
                    } else {
                        Sequence.Tree.Path path3 = new Sequence.Tree.Path(path, path.getLength() - 1);
                        EventNode eventNode = (EventNode)treeNode;
                        Method method = eventNode.getEvent();
                        if (bl) {
                            int n;
                            List list3 = (List)Sequence.Tree.get((Sequence)list, (Sequence.Tree.Path)path3);
                            Sequence.Tree.Path path4 = new Sequence.Tree.Path(path);
                            int n3 = path3.getLength();
                            int n4 = list3.getLength();
                            for (n = 0; n < n4; ++n) {
                                path4.update(n3, Integer.valueOf(n));
                                if (!treeView.isNodeChecked(path4)) break;
                            }
                            if (n == n4) {
                                treeView.setNodeChecked(path3, bl);
                            }
                            eventLogger.getIncludeEvents().add(method);
                        } else {
                            treeView.setNodeChecked(path3, bl);
                            eventLogger.getIncludeEvents().remove(method);
                        }
                    }
                }
            }
        });
        this.sourceChanged(eventLogger, null);
    }

    public int getPreferredWidth(int n) {
        return this.content.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        return this.content.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        return this.content.getPreferredSize();
    }

    public void layout() {
        this.content.setLocation(0, 0);
        this.content.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void clearLog() {
        this.firedEventsTableView.getTableData().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sourceChanged(EventLogger eventLogger, Component component) {
        ArrayList arrayList;
        HashMap hashMap = new HashMap();
        for (Object object : eventLogger.getDeclaredEvents()) {
            Class clazz = ((Method)object).getDeclaringClass();
            arrayList = (ArrayList)hashMap.get(clazz);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(clazz, (Object)arrayList);
            }
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList((Comparator)treeNodeComparator);
        this.declaredEventsTreeView.setTreeData((List)arrayList2);
        this.updating = true;
        try {
            Object object;
            for (Class clazz : hashMap) {
                arrayList = new TreeBranch(clazz.getSimpleName());
                arrayList.setComparator((Comparator)treeNodeComparator);
                arrayList2.add((Object)arrayList);
                for (Method method : (ArrayList)hashMap.get((Object)clazz)) {
                    arrayList.add((TreeNode)new EventNode(method));
                    eventLogger.getIncludeEvents().add(method);
                }
            }
            object = Sequence.Tree.depthFirstIterator((Sequence)arrayList2);
            while (object.hasNext()) {
                object.next();
                this.declaredEventsTreeView.setNodeChecked(object.getPath(), true);
            }
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public void eventIncluded(EventLogger eventLogger, Method method) {
        this.setEventIncluded(method, true);
    }

    @Override
    public void eventExcluded(EventLogger eventLogger, Method method) {
        this.setEventIncluded(method, false);
    }

    private void setEventIncluded(Method method, boolean bl) {
        List list = this.declaredEventsTreeView.getTreeData();
        Sequence.Tree.ItemIterator itemIterator = Sequence.Tree.depthFirstIterator((Sequence)list);
        while (itemIterator.hasNext()) {
            EventNode eventNode;
            TreeNode treeNode = (TreeNode)itemIterator.next();
            if (!(treeNode instanceof EventNode) || (eventNode = (EventNode)treeNode).getEvent() != method) continue;
            this.declaredEventsTreeView.setNodeChecked(itemIterator.getPath(), bl);
            break;
        }
    }

    @Override
    public void eventFired(EventLogger eventLogger, Method method, Object[] objectArray) {
        HashMap hashMap = new HashMap();
        hashMap.put((Object)"interface", (Object)method.getDeclaringClass().getSimpleName());
        hashMap.put((Object)"method", (Object)method.getName());
        hashMap.put((Object)"arguments", (Object)Arrays.toString(objectArray));
        List list = this.firedEventsTableView.getTableData();
        final int n = list.add((Object)hashMap);
        ApplicationContext.queueCallback((Runnable)new Runnable(){

            @Override
            public void run() {
                Bounds bounds = EventLoggerSkin.this.firedEventsTableView.getRowBounds(n);
                EventLoggerSkin.this.firedEventsTableView.scrollAreaToVisible(bounds);
            }
        });
    }

    private static class EventNode
    extends TreeNode {
        private Method event;

        public EventNode(Method method) {
            super(method.getName());
            this.event = method;
        }

        public Method getEvent() {
            return this.event;
        }
    }

    private static class TreeNodeComparator
    implements Comparator<TreeNode> {
        private TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode treeNode, TreeNode treeNode2) {
            return treeNode.getText().compareTo(treeNode2.getText());
        }
    }
}

