/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.beans;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.beans.BeanDictionaryListener;
import org.apache.pivot.beans.PropertyNotFoundException;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;

public class BeanDictionary
implements Dictionary<String, Object>,
Iterable<String> {
    private Object bean;
    private boolean ignoreReadOnlyProperties;
    private HashMap<Class<?>, Object> beanListenerProxies = null;
    private BeanInvocationHandler invocationHandler = null;
    private HashSet<String> notifyingProperties = null;
    private BeanDictionaryListenerList beanDictionaryListeners = null;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String FIELD_PREFIX = "~";
    public static final String LISTENERS_SUFFIX = "Listeners";
    public static final String PROPERTY_CHANGE_SUFFIX = "Changed";

    public BeanDictionary() {
        this(null);
    }

    public BeanDictionary(Object object) {
        this(object, false);
    }

    public BeanDictionary(Object object, boolean bl) {
        this.ignoreReadOnlyProperties = bl;
        this.setBean(object);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object object) {
        Object object2 = this.bean;
        if (object != object2) {
            if (this.beanDictionaryListeners != null && object2 != null) {
                this.unregisterBeanListeners();
            }
            this.bean = object;
            if (this.beanDictionaryListeners != null) {
                if (object != null) {
                    this.registerBeanListeners();
                }
                this.beanDictionaryListeners.beanChanged(this, object2);
            }
        }
    }

    @Override
    public Object get(String string) {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Object object = null;
        if (string.startsWith(FIELD_PREFIX)) {
            Field field = this.getField(string.substring(1));
            if (field != null) {
                try {
                    object = field.get(this.bean);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        } else {
            Method method = this.getGetterMethod(string);
            if (method != null) {
                try {
                    object = method.invoke(this.bean, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return object;
    }

    @Override
    public Object put(String string, Object object) {
        Class<?> clazz;
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (string.startsWith(FIELD_PREFIX)) {
            Class<?> clazz2;
            Field field = this.getField(string.substring(1));
            if (field == null) {
                throw new PropertyNotFoundException("Property \"" + string + "\"" + " does not exist or is final.");
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != (clazz2 = object.getClass()) && clazz2 == String.class) {
                object = BeanDictionary.coerce((String)object, clazz3);
            }
            try {
                field.set(this.bean, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        Method method = null;
        if (object != null) {
            method = this.getSetterMethod(string, object.getClass());
        }
        if (method == null && (clazz = this.getType(string)) != null) {
            method = this.getSetterMethod(string, clazz);
            if (object instanceof String) {
                object = BeanDictionary.coerce((String)object, clazz);
            }
        }
        if (method == null) {
            throw new PropertyNotFoundException("Property \"" + string + "\"" + " does not exist or is read-only.");
        }
        try {
            method.invoke(this.bean, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return null;
    }

    @Override
    public Object remove(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(String string) {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        boolean bl = string.startsWith(FIELD_PREFIX) ? this.getField(string.substring(1)) != null : this.getGetterMethod(string) != null;
        return bl;
    }

    public boolean isReadOnly(String string) {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        return BeanDictionary.isReadOnly(this.bean.getClass(), string);
    }

    public boolean isNotifying(String string) {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        if (this.beanDictionaryListeners == null) {
            this.beanDictionaryListeners = new BeanDictionaryListenerList();
            this.beanListenerProxies = new HashMap();
            this.invocationHandler = new BeanInvocationHandler();
            this.notifyingProperties = new HashSet();
            this.registerBeanListeners();
        }
        return this.notifyingProperties.contains(string);
    }

    public Class<?> getType(String string) {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        return BeanDictionary.getType(this.bean.getClass(), string);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.bean == null) {
            throw new IllegalStateException("bean is null.");
        }
        return new PropertyIterator();
    }

    private Method getGetterMethod(String string) {
        return BeanDictionary.getGetterMethod(this.bean.getClass(), string);
    }

    private Field getField(String string) {
        return BeanDictionary.getField(this.bean.getClass(), string);
    }

    private Method getSetterMethod(String string, Class<?> clazz) {
        return BeanDictionary.getSetterMethod(this.bean.getClass(), string, clazz);
    }

    private void registerBeanListeners() {
        Method[] methodArray = this.bean.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Method method = methodArray[i];
            if (!ListenerList.class.isAssignableFrom(method.getReturnType()) || (method.getModifiers() & 8) != 0 || (typeArray = (parameterizedType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class clazz = (Class)typeArray[0];
            if (!clazz.isInterface()) {
                throw new RuntimeException(clazz.getName() + " is not an interface.");
            }
            Method[] methodArray2 = clazz.getMethods();
            for (int j = 0; j < methodArray2.length; ++j) {
                object4 = methodArray2[j];
                object3 = ((Method)object4).getName();
                if (!((String)object3).endsWith(PROPERTY_CHANGE_SUFFIX) || !this.containsKey((String)(object2 = ((String)object3).substring(0, ((String)object3).length() - PROPERTY_CHANGE_SUFFIX.length())))) continue;
                this.notifyingProperties.add((String)object2);
            }
            try {
                object = method.invoke(this.bean, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            object4 = this.beanListenerProxies.get(clazz);
            if (object4 == null) {
                object4 = Proxy.newProxyInstance(ThreadUtilities.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.invocationHandler);
                this.beanListenerProxies.put(clazz, object4);
            }
            object3 = object.getClass();
            try {
                object2 = ((Class)object3).getMethod("add", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            try {
                ((Method)object2).invoke(object, object4);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    private void unregisterBeanListeners() {
        Method[] methodArray = this.bean.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method;
            Object object;
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Method method2 = methodArray[i];
            if (!ListenerList.class.isAssignableFrom(method2.getReturnType()) || (method2.getModifiers() & 8) != 0 || (typeArray = (parameterizedType = (ParameterizedType)method2.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class clazz = (Class)typeArray[0];
            try {
                object = method2.invoke(this.bean, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            Object object2 = this.beanListenerProxies.get(clazz);
            if (object2 == null) {
                throw new IllegalStateException("Listener proxy is null.");
            }
            Class<?> clazz2 = object.getClass();
            try {
                method = clazz2.getMethod("remove", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            try {
                method.invoke(object, object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        this.notifyingProperties.clear();
    }

    public static boolean isReadOnly(Class<?> clazz, String string) {
        Method method;
        Field field;
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        boolean bl = true;
        bl = string.startsWith(FIELD_PREFIX) ? (field = BeanDictionary.getField(clazz, string.substring(1))) == null || (field.getModifiers() & 0x10) != 0 : (method = BeanDictionary.getSetterMethod(clazz, string, BeanDictionary.getType(clazz, string))) == null;
        return bl;
    }

    public static Class<?> getType(Class<?> clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Class<?> clazz2 = null;
        if (string.startsWith(FIELD_PREFIX)) {
            Field field = BeanDictionary.getField(clazz, string.substring(1));
            if (field != null) {
                clazz2 = field.getType();
            }
        } else {
            Method method = BeanDictionary.getGetterMethod(clazz, string);
            if (method != null) {
                clazz2 = method.getReturnType();
            }
        }
        return clazz2;
    }

    public static Field getField(Class<?> clazz, String string) {
        Field field = null;
        try {
            field = clazz.getField(string);
            int n = field.getModifiers();
            if ((n & 1) == 0 || (n & 8) > 0 || (n & 0x10) > 0) {
                field = null;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Method getGetterMethod(Class<?> clazz, String string) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Method method = null;
        try {
            method = clazz.getMethod(GET_PREFIX + string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clazz.getMethod(IS_PREFIX + string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public static Method getSetterMethod(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = null;
        if (clazz2 != null) {
            Class<?>[] classArray;
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            String string2 = SET_PREFIX + string;
            try {
                method = clazz.getMethod(string2, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                classArray = clazz2.getSuperclass();
                method = BeanDictionary.getSetterMethod(clazz, string, classArray);
            }
            if (method == null) {
                try {
                    classArray = clazz2.getField("TYPE");
                    Class clazz3 = (Class)classArray.get(null);
                    try {
                        method = clazz.getMethod(string2, clazz3);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (method == null) {
                classArray = clazz2.getInterfaces();
                int n = 0;
                int n2 = classArray.length;
                while (method == null && n < n2) {
                    Class<?> clazz4 = classArray[n++];
                    method = BeanDictionary.getSetterMethod(clazz, string, clazz4);
                }
            }
        }
        return method;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object coerce(String string, Class<?> clazz) {
        if (clazz == Boolean.class) return Boolean.parseBoolean(string);
        if (clazz == Boolean.TYPE) {
            return Boolean.parseBoolean(string);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            if (string.length() != 1) throw new IllegalArgumentException("\"" + string + "\" is not a valid character");
            return Character.valueOf(string.charAt(0));
        }
        if (clazz == Byte.class) return Byte.parseByte(string);
        if (clazz == Byte.TYPE) {
            return Byte.parseByte(string);
        }
        if (clazz == Short.class) return Short.parseShort(string);
        if (clazz == Short.TYPE) {
            return Short.parseShort(string);
        }
        if (clazz == Integer.class) return Integer.parseInt(string);
        if (clazz == Integer.TYPE) {
            return Integer.parseInt(string);
        }
        if (clazz == Long.class) return Long.parseLong(string);
        if (clazz == Long.TYPE) {
            return Long.parseLong(string);
        }
        if (clazz == Float.class) return Float.valueOf(Float.parseFloat(string));
        if (clazz == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (clazz == Double.class) return Double.parseDouble(string);
        if (clazz != Double.TYPE) return string;
        return Double.parseDouble(string);
    }

    public ListenerList<BeanDictionaryListener> getBeanDictionaryListeners() {
        if (this.beanDictionaryListeners == null) {
            this.beanDictionaryListeners = new BeanDictionaryListenerList();
            this.beanListenerProxies = new HashMap();
            this.invocationHandler = new BeanInvocationHandler();
            this.notifyingProperties = new HashSet();
            if (this.bean != null) {
                this.registerBeanListeners();
            }
        }
        return this.beanDictionaryListeners;
    }

    private static class BeanDictionaryListenerList
    extends ListenerList<BeanDictionaryListener>
    implements BeanDictionaryListener {
        private BeanDictionaryListenerList() {
        }

        @Override
        public void beanChanged(BeanDictionary beanDictionary, Object object) {
            for (BeanDictionaryListener beanDictionaryListener : this) {
                beanDictionaryListener.beanChanged(beanDictionary, object);
            }
        }

        @Override
        public void propertyChanged(BeanDictionary beanDictionary, String string) {
            for (BeanDictionaryListener beanDictionaryListener : this) {
                beanDictionaryListener.propertyChanged(beanDictionary, string);
            }
        }
    }

    private class BeanInvocationHandler
    implements InvocationHandler {
        private BeanInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            String string = method.getName();
            if (string.endsWith(BeanDictionary.PROPERTY_CHANGE_SUFFIX)) {
                object2 = string.substring(0, string.length() - BeanDictionary.PROPERTY_CHANGE_SUFFIX.length());
                if (BeanDictionary.this.notifyingProperties.contains(object2)) {
                    BeanDictionary.this.beanDictionaryListeners.propertyChanged(BeanDictionary.this, (String)object2);
                }
            }
            object2 = null;
            Class<?> clazz = method.getReturnType();
            if (clazz == Vote.class) {
                object2 = Vote.APPROVE;
            } else if (clazz == Boolean.TYPE) {
                object2 = false;
            }
            return object2;
        }
    }

    private class PropertyIterator
    implements Iterator<String> {
        private Method[] methods = null;
        private Field[] fields = null;
        int i = 0;
        int j = 0;
        private String nextProperty = null;

        public PropertyIterator() {
            Class<?> clazz = BeanDictionary.this.bean.getClass();
            this.methods = clazz.getMethods();
            this.fields = clazz.getFields();
            this.nextProperty();
        }

        @Override
        public boolean hasNext() {
            return this.nextProperty != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextProperty;
            this.nextProperty();
            return string;
        }

        private void nextProperty() {
            AccessibleObject accessibleObject;
            this.nextProperty = null;
            while (this.i < this.methods.length && this.nextProperty == null) {
                if (((Method)(accessibleObject = this.methods[this.i++])).getParameterTypes().length != 0 || (((Method)accessibleObject).getModifiers() & 8) != 0) continue;
                String string = ((Method)accessibleObject).getName();
                String string2 = null;
                if (string.startsWith(BeanDictionary.GET_PREFIX)) {
                    string2 = BeanDictionary.GET_PREFIX;
                } else if (string.startsWith(BeanDictionary.IS_PREFIX)) {
                    string2 = BeanDictionary.IS_PREFIX;
                }
                if (string2 != null) {
                    int n = string2.length();
                    this.nextProperty = Character.toLowerCase(string.charAt(n)) + string.substring(n + 1);
                }
                if (this.nextProperty == null || !BeanDictionary.this.ignoreReadOnlyProperties || !BeanDictionary.this.isReadOnly(this.nextProperty)) continue;
                this.nextProperty = null;
            }
            if (this.nextProperty == null) {
                while (this.j < this.fields.length && this.nextProperty == null) {
                    int n;
                    if (((n = ((Field)(accessibleObject = this.fields[this.j++])).getModifiers()) & 1) != 0 && (n & 8) == 0) {
                        this.nextProperty = BeanDictionary.FIELD_PREFIX + ((Field)accessibleObject).getName();
                    }
                    if (this.nextProperty == null || !BeanDictionary.this.ignoreReadOnlyProperties || (n & 0x10) == 0) continue;
                    this.nextProperty = null;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

