/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ArrayQueue<T>
implements Queue<T>,
Serializable {
    private static final long serialVersionUID = -3856732506886968324L;
    private ArrayList<T> arrayList = new ArrayList();
    private transient Queue.QueueListenerList<T> queueListeners = new Queue.QueueListenerList();

    public ArrayQueue() {
        this(null);
    }

    public ArrayQueue(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    public ArrayQueue(int n) {
        this.ensureCapacity(n);
    }

    @Override
    public void enqueue(T t) {
        if (this.getComparator() == null) {
            this.arrayList.insert(t, 0);
        } else {
            this.arrayList.add(t);
        }
        this.queueListeners.itemEnqueued(this, t);
    }

    @Override
    public T dequeue() {
        int n = this.arrayList.getLength();
        if (n == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T t = this.arrayList.remove(n - 1, 1).get(0);
        this.queueListeners.itemDequeued(this, t);
        return t;
    }

    @Override
    public T peek() {
        T t = null;
        int n = this.arrayList.getLength();
        if (n > 0) {
            t = this.arrayList.get(n - 1);
        }
        return t;
    }

    @Override
    public void clear() {
        if (this.arrayList.getLength() > 0) {
            this.arrayList.clear();
            this.queueListeners.queueCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.getLength() == 0;
    }

    @Override
    public int getLength() {
        return this.arrayList.getLength();
    }

    public void ensureCapacity(int n) {
        this.arrayList.ensureCapacity(n);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.arrayList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.arrayList.setComparator(comparator);
        this.queueListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.arrayList.iterator());
    }

    @Override
    public ListenerList<QueueListener<T>> getQueueListeners() {
        return this.queueListeners;
    }
}

