/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ListenerList;

public class EnumSet<E extends Enum<E>>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 3544488357505145448L;
    private Class<E> enumClass;
    private E[] elements;
    private boolean[] members;
    private int count = 0;
    private transient Set.SetListenerList<E> setListeners = new Set.SetListenerList();

    public EnumSet(Class<E> clazz) {
        this.enumClass = clazz;
        this.elements = (Enum[])clazz.getEnumConstants();
        this.members = new boolean[this.elements.length];
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        int n = ((Enum)e).ordinal();
        if (!this.members[n]) {
            this.members[n] = true;
            bl = true;
            ++this.count;
            this.setListeners.elementAdded(this, e);
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        boolean bl = false;
        int n = ((Enum)e).ordinal();
        if (this.members[n]) {
            this.members[n] = false;
            bl = true;
            --this.count;
            this.setListeners.elementRemoved(this, e);
        }
        return bl;
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            this.members = new boolean[this.members.length];
            this.count = 0;
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public boolean contains(E e) {
        return this.members[((Enum)e).ordinal()];
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    private class ElementIterator
    implements Iterator<E> {
        private int i = 0;
        private E next = null;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (this.i < EnumSet.this.elements.length && !EnumSet.this.members[this.i]) {
                    ++this.i;
                }
                this.next = this.i < EnumSet.this.elements.length ? EnumSet.this.elements[this.i] : null;
            }
            return this.next != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = this.next;
            this.next = null;
            ++this.i;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

