/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.FilteredListListener;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.EmptyIterator;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class FilteredList<T>
implements List<T> {
    private List<T> source = null;
    private Filter<T> filter = null;
    private Comparator<T> comparator = null;
    private ArrayList<T> view = null;
    private boolean updating = false;
    private ListListener<T> listListener = new ListListener<T>(){

        @Override
        public void itemInserted(List<T> list, int n) {
            if (!FilteredList.this.updating) {
                Object t = list.get(n);
                if (FilteredList.this.filter == null || FilteredList.this.filter.include(t)) {
                    int n2 = FilteredList.this.view.add(t);
                    FilteredList.this.listListeners.itemInserted(FilteredList.this, n2);
                }
            }
        }

        @Override
        public void itemsRemoved(List<T> list, int n, Sequence<T> sequence) {
            if (!FilteredList.this.updating) {
                int n2 = sequence.getLength();
                for (int i = 0; i < n2; ++i) {
                    Object t = sequence.get(i);
                    int n3 = FilteredList.this.view.indexOf(t);
                    if (n3 == -1) continue;
                    Sequence sequence2 = FilteredList.this.view.remove(n3, 1);
                    FilteredList.this.listListeners.itemsRemoved(FilteredList.this, n3, sequence2);
                }
            }
        }

        @Override
        public void itemUpdated(List<T> list, int n, T t) {
            if (!FilteredList.this.updating) {
                Object t2 = list.get(n);
                int n2 = FilteredList.this.view.indexOf(t);
                if (FilteredList.this.filter == null || FilteredList.this.filter.include(t2)) {
                    if (n2 == -1) {
                        n2 = FilteredList.this.view.add(t2);
                        FilteredList.this.listListeners.itemInserted(FilteredList.this, n2);
                    } else {
                        Comparator comparator = FilteredList.this.view.getComparator();
                        if (comparator == null) {
                            n2 = FilteredList.this.view.add(t2);
                            FilteredList.this.listListeners.itemInserted(FilteredList.this, n2);
                        } else {
                            int n3 = ArrayList.binarySearch(FilteredList.this.view, t2, comparator);
                            if (n3 == n2) {
                                FilteredList.this.view.update(n2, t2);
                            } else {
                                Sequence sequence = FilteredList.this.view.remove(n3, 1);
                                FilteredList.this.listListeners.itemsRemoved(FilteredList.this, n3, sequence);
                                n2 = FilteredList.this.view.add(t2);
                                FilteredList.this.listListeners.itemInserted(FilteredList.this, n2);
                            }
                        }
                    }
                } else if (n2 != -1) {
                    Sequence sequence = FilteredList.this.view.remove(n2, 1);
                    FilteredList.this.listListeners.itemsRemoved(FilteredList.this, n2, sequence);
                }
            }
        }

        @Override
        public void listCleared(List<T> list) {
            if (!FilteredList.this.updating) {
                FilteredList.this.view.clear();
                FilteredList.this.listListeners.listCleared(FilteredList.this);
            }
        }

        @Override
        public void comparatorChanged(List<T> list, Comparator<T> comparator) {
        }
    };
    private List.ListListenerList<T> listListeners = new List.ListListenerList();
    private FilteredListListenerList<T> filteredListListeners = new FilteredListListenerList();

    public FilteredList() {
        this(null, null);
    }

    public FilteredList(List<T> list) {
        this(list, null);
    }

    public FilteredList(Filter<T> filter) {
        this(null, filter);
    }

    public FilteredList(List<T> list, Filter<T> filter) {
        this.setSource(list);
        this.setFilter(filter);
    }

    public List<T> getSource() {
        return this.source;
    }

    public void setSource(List<T> list) {
        List<T> list2 = this.source;
        if (list2 != list) {
            if (this.view != null) {
                this.view.clear();
                this.listListeners.listCleared(this);
            }
            if (list2 != null) {
                list2.getListListeners().remove(this.listListener);
            }
            this.source = list;
            this.filteredListListeners.sourceChanged(this, list2);
            if (list == null) {
                this.view = null;
            } else {
                this.view = new ArrayList();
                for (Object t : list) {
                    if (this.filter != null && !this.filter.include(t)) continue;
                    int n = this.view.add(t);
                    this.listListeners.itemInserted(this, n);
                }
                this.view.setComparator(this.comparator);
            }
            if (list != null) {
                list.getListListeners().add(this.listListener);
            }
        }
    }

    public Filter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<T> filter) {
        Filter<T> filter2 = this.filter;
        if (filter2 != filter) {
            if (this.view != null) {
                this.view.clear();
                this.listListeners.listCleared(this);
            }
            this.filter = filter;
            this.filteredListListeners.filterChanged(this, filter2);
            if (this.view != null) {
                for (Object t : this.source) {
                    if (filter != null && !filter.include(t)) continue;
                    int n = this.view.add(t);
                    this.listListeners.itemInserted(this, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(T t) {
        if (this.view == null) {
            throw new IllegalStateException();
        }
        int n = -1;
        this.updating = true;
        try {
            if (this.filter != null && this.filter.include(t)) {
                n = this.view.add(t);
                this.listListeners.itemInserted(this, n);
            }
            this.source.add(t);
        }
        finally {
            this.updating = false;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(T t, int n) {
        if (this.view == null) {
            throw new IllegalStateException();
        }
        this.updating = true;
        try {
            if (this.filter != null && this.filter.include(t)) {
                this.view.insert(t, n);
                this.listListeners.itemInserted(this, n);
            }
            this.source.add(t);
        }
        finally {
            this.updating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T update(int n, T t) {
        T t2;
        if (this.view == null) {
            throw new IllegalStateException();
        }
        if (this.filter != null && !this.filter.include(t)) {
            throw new IllegalArgumentException();
        }
        this.updating = true;
        try {
            t2 = this.view.update(n, t);
            this.listListeners.itemUpdated(this, n, t2);
            this.source.update(this.source.indexOf(t2), t);
        }
        finally {
            this.updating = false;
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(T t) {
        int n;
        if (this.view == null) {
            throw new IllegalStateException();
        }
        this.updating = true;
        try {
            n = this.view.indexOf(t);
            if (n != -1) {
                Sequence<T> sequence = this.view.remove(n, 1);
                this.listListeners.itemsRemoved(this, n, sequence);
            }
            this.source.remove(t);
        }
        finally {
            this.updating = false;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence<T> remove(int n, int n2) {
        Sequence<T> sequence;
        if (this.view == null) {
            throw new IllegalStateException();
        }
        this.updating = true;
        try {
            sequence = this.view.remove(n, n2);
            this.listListeners.itemsRemoved(this, n, sequence);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                this.source.remove(sequence.get(i));
            }
        }
        finally {
            this.updating = false;
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.view == null) {
            throw new IllegalStateException();
        }
        this.updating = true;
        try {
            Sequence<T> sequence = this.view.remove(0, this.view.getLength());
            this.listListeners.listCleared(this);
            int n = sequence.getLength();
            for (int i = 0; i < n; ++i) {
                this.source.remove(sequence.get(i));
            }
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public T get(int n) {
        return this.view == null ? null : (T)this.view.get(n);
    }

    @Override
    public int indexOf(T t) {
        return this.view == null ? -1 : this.view.indexOf(t);
    }

    @Override
    public boolean isEmpty() {
        return this.view == null ? true : this.view.isEmpty();
    }

    @Override
    public int getLength() {
        return this.view == null ? 0 : this.view.getLength();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.comparator;
        this.comparator = comparator;
        if (this.view != null) {
            this.view.setComparator(comparator);
        }
        this.listListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return this.view == null ? new EmptyIterator() : new ImmutableIterator(this.view.iterator());
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        return this.listListeners;
    }

    public ListenerList<FilteredListListener<T>> getFilteredListListeners() {
        return this.filteredListListeners;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static class FilteredListListenerList<T>
    extends ListenerList<FilteredListListener<T>>
    implements FilteredListListener<T> {
        private FilteredListListenerList() {
        }

        @Override
        public void sourceChanged(FilteredList<T> filteredList, List<T> list) {
            for (FilteredListListener filteredListListener : this) {
                filteredListListener.sourceChanged(filteredList, list);
            }
        }

        @Override
        public void filterChanged(FilteredList<T> filteredList, Filter<T> filter) {
            for (FilteredListListener filteredListListener : this) {
                filteredListListener.filterChanged(filteredList, filter);
            }
        }
    }
}

