/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class LinkedList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 2100691224732602812L;
    private Node<T> first = null;
    private Node<T> last = null;
    private int length = 0;
    private Comparator<T> comparator = null;
    private transient int modificationCount = 0;
    private transient List.ListListenerList<T> listListeners;

    public LinkedList() {
    }

    public LinkedList(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public LinkedList(T ... TArray) {
        for (int i = 0; i < TArray.length; ++i) {
            this.add(TArray[i]);
        }
    }

    public LinkedList(Sequence<T> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            this.add(sequence.get(i));
        }
    }

    @Override
    public int add(T t) {
        int n;
        if (this.comparator == null) {
            n = this.length;
            this.insert(t, n);
        } else {
            n = 0;
            Node node = null;
            Node node2 = null;
            if (this.length > 0) {
                node = this.first;
                while (node != null && this.comparator.compare(t, node.item) > 0) {
                    node = node.next;
                    ++n;
                }
                node2 = node == null ? this.last : node.previous;
            }
            this.insert(t, node2, node);
            ++this.length;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemInserted(this, n);
            }
        }
        return n;
    }

    @Override
    public void insert(T t, int n) {
        LinkedList.verifyIndexBounds(n, 0, this.length);
        Node<T> node = null;
        Node node2 = null;
        if (this.length > 0) {
            node = n == this.length ? null : this.getNode(n);
            node2 = node == null ? this.last : ((Node)node).previous;
            this.verifyLocation(t, node2, node);
        }
        this.insert(t, node2, node);
        ++this.length;
        ++this.modificationCount;
        if (this.listListeners != null) {
            this.listListeners.itemInserted(this, n);
        }
    }

    private void insert(T t, Node<T> node, Node<T> node2) {
        Node<T> node3 = new Node<T>(node, node2, t);
        if (node == null) {
            this.first = node3;
        } else {
            ((Node)node).next = (Node)node3;
        }
        if (node2 == null) {
            this.last = node3;
        } else {
            ((Node)node2).previous = (Node)node3;
        }
    }

    @Override
    public T update(int n, T t) {
        LinkedList.verifyIndexBounds(n, 0, this.length - 1);
        Node<T> node = this.getNode(n);
        Object object = ((Node)node).item;
        if (object != t) {
            this.verifyLocation(t, ((Node)node).previous, ((Node)node).next);
            ((Node)node).item = t;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemUpdated(this, n, object);
            }
        }
        return (T)object;
    }

    private void verifyLocation(T t, Node<T> node, Node<T> node2) {
        if (this.comparator != null && (node != null && this.comparator.compare(t, ((Node)node).item) == -1 || node2 != null && this.comparator.compare(t, ((Node)node2).item) == 1)) {
            throw new IllegalArgumentException("Illegal item modification.");
        }
    }

    @Override
    public int remove(T t) {
        int n = 0;
        LinkedListItemIterator linkedListItemIterator = new LinkedListItemIterator();
        while (linkedListItemIterator.hasNext()) {
            if (linkedListItemIterator.next() == t) {
                linkedListItemIterator.remove();
                break;
            }
            ++n;
        }
        if (!linkedListItemIterator.hasNext()) {
            n = -1;
        }
        return n;
    }

    @Override
    public Sequence<T> remove(int n, int n2) {
        LinkedList.verifyIndexBounds(n, n2, 0, this.length);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (n2 > 0) {
            Node<T> node;
            Node<T> node2 = node = this.getNode(n);
            for (int i = 0; i < n2; ++i) {
                linkedList.add(((Node)node2).item);
                node2 = ((Node)node2).next;
            }
            node2 = node2 == null ? this.last : ((Node)node2).previous;
            if (((Node)node).previous != null) {
                ((Node)node).previous.next = ((Node)node2).next;
            }
            if (n + n2 == this.length) {
                this.last = ((Node)node).previous;
            }
            if (((Node)node2).next != null) {
                ((Node)node2).next.previous = ((Node)node).previous;
            }
            if (n == 0) {
                this.first = ((Node)node2).next;
            }
            ((Node)node).previous = null;
            ((Node)node2).next = null;
            this.length -= n2;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemsRemoved(this, n, linkedList);
            }
        }
        return linkedList;
    }

    @Override
    public void clear() {
        if (this.length > 0) {
            this.first = null;
            this.last = null;
            this.length = 0;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.listCleared(this);
            }
        }
    }

    @Override
    public T get(int n) {
        LinkedList.verifyIndexBounds(n, 0, this.length - 1);
        Node<T> node = this.getNode(n);
        return (T)((Node)node).item;
    }

    private Node<T> getNode(int n) {
        Node node;
        if (n == 0) {
            node = this.first;
        } else if (n == this.length - 1) {
            node = this.last;
        } else if (n < this.length / 2) {
            node = this.first;
            for (int i = 0; i < n; ++i) {
                node = node.next;
            }
        } else {
            node = this.last;
            for (int i = this.length - 1; i > n; --i) {
                node = node.previous;
            }
        }
        return node;
    }

    @Override
    public int indexOf(T t) {
        int n = 0;
        Node node = this.first;
        while (node != null && !(t == null ? node.item == null : t.equals(node.item))) {
            node = node.next;
            ++n;
        }
        if (node == null) {
            n = -1;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.comparator;
        if (comparator != null) {
            Object[] objectArray = new Object[this.length];
            int n = 0;
            for (Object object2 : this) {
                objectArray[n++] = object2;
            }
            Arrays.sort(objectArray, comparator);
            this.first = null;
            Object object = null;
            for (n = 0; n < this.length; ++n) {
                Object object2;
                object2 = object;
                object = new Node<Object>((Node<Object>)object2, null, objectArray[n]);
                if (object2 == null) {
                    this.first = object;
                    continue;
                }
                ((Node)object2).next = (Node)object;
            }
            this.last = object;
            ++this.modificationCount;
        }
        this.comparator = comparator;
        if (this.listListeners != null) {
            this.listListeners.comparatorChanged(this, comparator2);
        }
    }

    @Override
    public List.ItemIterator<T> iterator() {
        return new LinkedListItemIterator();
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        if (this.listListeners == null) {
            this.listListeners = new List.ListListenerList();
        }
        return this.listListeners;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof LinkedList) {
            LinkedList linkedList = (LinkedList)object;
            if (this.getLength() == linkedList.getLength()) {
                Iterator iterator = this.iterator();
                Iterator iterator2 = linkedList.iterator();
                for (bl = true; iterator.hasNext() && iterator2.hasNext() && bl; bl &= iterator.next().equals(iterator2.next())) {
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        int n = 0;
        for (Object e : this) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(e);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static void verifyIndexBounds(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException("index " + n + " out of bounds.");
        }
    }

    private static void verifyIndexBounds(int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n < n3) {
            throw new IndexOutOfBoundsException("index " + n + " out of bounds.");
        }
        if (n + n2 > n4) {
            throw new IndexOutOfBoundsException("index + count " + n + "," + n2 + " out of range.");
        }
    }

    private class LinkedListItemIterator
    implements List.ItemIterator<T> {
        private int index = 0;
        private Node<T> current = null;
        private boolean forward = false;
        private int modificationCount;

        public LinkedListItemIterator() {
            this.modificationCount = LinkedList.this.modificationCount;
        }

        @Override
        public boolean hasNext() {
            if (this.modificationCount != LinkedList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < LinkedList.this.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.current = LinkedList.this.first;
            } else if (this.forward) {
                this.current = this.current.next;
            }
            ++this.index;
            this.forward = true;
            return this.current.item;
        }

        @Override
        public boolean hasPrevious() {
            if (this.modificationCount != LinkedList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (!this.forward) {
                this.current = this.current.previous;
            }
            --this.index;
            this.forward = false;
            return this.current.item;
        }

        @Override
        public void toStart() {
            this.index = 0;
            this.current = null;
            this.forward = true;
        }

        @Override
        public void toEnd() {
            this.index = LinkedList.this.length;
            this.current = LinkedList.this.last;
            this.forward = true;
        }

        @Override
        public void insert(T t) {
            Node node = null;
            Node node2 = null;
            if (LinkedList.this.length > 0) {
                if (this.index == 0) {
                    node = LinkedList.this.first;
                } else if (this.index < LinkedList.this.length) {
                    if (this.forward) {
                        node = this.current.next;
                        node2 = this.current;
                    } else {
                        node = this.current;
                        node2 = this.current.previous;
                    }
                } else {
                    node2 = LinkedList.this.last;
                }
                LinkedList.this.verifyLocation(t, node2, node);
                if (!this.forward) {
                    ++this.index;
                }
            }
            LinkedList.this.insert(t, node2, node);
            LinkedList.this.length++;
            ++this.modificationCount;
            LinkedList.this.modificationCount++;
            if (LinkedList.this.listListeners != null) {
                LinkedList.this.listListeners.itemInserted(LinkedList.this, this.index);
            }
        }

        @Override
        public void update(T t) {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object object = this.current.item;
            if (object != t) {
                LinkedList.this.verifyLocation(t, this.current.previous, this.current.next);
                this.current.item = t;
                ++this.modificationCount;
                LinkedList.this.modificationCount++;
                if (LinkedList.this.listListeners != null) {
                    LinkedList.this.listListeners.itemUpdated(LinkedList.this, this.index, object);
                }
            }
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object object = this.current.item;
            if (this.current.previous == null) {
                LinkedList.this.first = this.current.next;
            } else {
                this.current.previous.next = this.current.next;
            }
            if (this.current.next == null) {
                LinkedList.this.last = this.current.previous;
            } else {
                this.current.next.previous = this.current.previous;
            }
            if (this.forward) {
                this.current = this.current.previous;
                --this.index;
            } else {
                this.current = this.current.next;
            }
            LinkedList.this.length--;
            ++this.modificationCount;
            LinkedList.this.modificationCount++;
            if (LinkedList.this.listListeners != null) {
                LinkedList<Object> linkedList = new LinkedList<Object>(object);
                LinkedList.this.listListeners.itemsRemoved(LinkedList.this, this.index, linkedList);
            }
        }
    }

    private static class Node<T>
    implements Serializable {
        private static final long serialVersionUID = -848937850230412572L;
        private Node<T> previous;
        private Node<T> next;
        private T item;

        public Node(Node<T> node, Node<T> node2, T t) {
            this.previous = node;
            this.next = node2;
            this.item = t;
        }
    }
}

