/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class LinkedQueue<T>
implements Queue<T>,
Serializable {
    private static final long serialVersionUID = 1598074020226109253L;
    private LinkedList<T> linkedList = new LinkedList();
    private transient Queue.QueueListenerList<T> queueListeners = new Queue.QueueListenerList();

    public LinkedQueue() {
        this(null);
    }

    public LinkedQueue(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    @Override
    public void enqueue(T t) {
        if (this.getComparator() == null) {
            this.linkedList.insert(t, 0);
        } else {
            this.linkedList.add(t);
        }
        this.queueListeners.itemEnqueued(this, t);
    }

    @Override
    public T dequeue() {
        int n = this.linkedList.getLength();
        if (n == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T t = this.linkedList.remove(n - 1, 1).get(0);
        this.queueListeners.itemDequeued(this, t);
        return t;
    }

    @Override
    public T peek() {
        T t = null;
        int n = this.linkedList.getLength();
        if (n > 0) {
            t = this.linkedList.get(n - 1);
        }
        return t;
    }

    @Override
    public void clear() {
        if (this.linkedList.getLength() > 0) {
            this.linkedList.clear();
            this.queueListeners.queueCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.getLength() == 0;
    }

    @Override
    public int getLength() {
        return this.linkedList.getLength();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.linkedList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.linkedList.setComparator(comparator);
        this.queueListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.linkedList.iterator());
    }

    @Override
    public ListenerList<QueueListener<T>> getQueueListeners() {
        return this.queueListeners;
    }
}

