/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListListener;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class MapList<K, V>
implements List<Dictionary.Pair<K, V>> {
    private Map<K, V> source;
    private ArrayList<Dictionary.Pair<K, V>> view = null;
    private boolean updating = false;
    private List.ListListenerList<Dictionary.Pair<K, V>> listListeners = new List.ListListenerList();
    private MapListListenerList<K, V> mapListListeners = new MapListListenerList();
    private MapListener<K, V> mapHandler = new MapListener.Adapter<K, V>(){

        @Override
        public void valueAdded(Map<K, V> map, K k) {
            if (!MapList.this.updating) {
                int n = MapList.this.view.add(new Dictionary.Pair(k, map.get(k)));
                MapList.this.listListeners.itemInserted(MapList.this, n);
            }
        }

        @Override
        public void valueUpdated(Map<K, V> map, K k, V v) {
            if (!MapList.this.updating) {
                Dictionary.Pair pair = new Dictionary.Pair(k, map.get(k));
                Dictionary.Pair pair2 = new Dictionary.Pair(k, v);
                int n = MapList.this.linearSearch(pair);
                if (n >= 0) {
                    MapList.this.view.update(n, pair);
                    MapList.this.listListeners.itemUpdated(MapList.this, n, pair2);
                } else {
                    int n2 = MapList.this.linearSearch(pair2);
                    assert (n2 >= 0);
                    Sequence sequence = MapList.this.view.remove(n2, 1);
                    MapList.this.listListeners.itemsRemoved(MapList.this, n2, sequence);
                    n = MapList.this.view.add(pair);
                    MapList.this.listListeners.itemInserted(MapList.this, n);
                }
            }
        }

        @Override
        public void valueRemoved(Map<K, V> map, K k, V v) {
            if (!MapList.this.updating) {
                Dictionary.Pair pair = new Dictionary.Pair(k, v);
                int n = MapList.this.linearSearch(pair);
                Sequence sequence = MapList.this.view.remove(n, 1);
                MapList.this.listListeners.itemsRemoved(MapList.this, n, sequence);
            }
        }

        @Override
        public void mapCleared(Map<K, V> map) {
            if (!MapList.this.updating) {
                MapList.this.view.clear();
                MapList.this.listListeners.listCleared(MapList.this);
            }
        }
    };

    public MapList() {
        this(null);
    }

    public MapList(Map<K, V> map) {
        this.setSource(map);
    }

    public Map<K, V> getSource() {
        return this.source;
    }

    public void setSource(Map<K, V> map) {
        Map<K, V> map2;
        if (map == null) {
            map = new HashMap();
        }
        if ((map2 = this.source) != map) {
            if (this.view != null) {
                this.view.clear();
                this.listListeners.listCleared(this);
            }
            if (map2 != null) {
                map2.getMapListeners().remove(this.mapHandler);
            }
            map.getMapListeners().add(this.mapHandler);
            this.source = map;
            this.mapListListeners.sourceChanged(this, map2);
            this.view = new ArrayList(map.getCount());
            for (Object t : map) {
                this.listListeners.itemInserted(this, this.view.add(new Dictionary.Pair(t, map.get(t))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(Dictionary.Pair<K, V> pair) {
        if (pair == null) {
            throw new IllegalArgumentException("Pair is null.");
        }
        if (this.source.containsKey(pair.key)) {
            throw new IllegalArgumentException("Duplicate keys not allowed.");
        }
        int n = this.view.add(pair);
        this.updating = true;
        try {
            this.source.put(pair.key, pair.value);
        }
        finally {
            this.updating = false;
        }
        this.listListeners.itemInserted(this, n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Dictionary.Pair<K, V> pair, int n) {
        if (pair == null) {
            throw new IllegalArgumentException("Pair is null.");
        }
        if (this.source.containsKey(pair.key)) {
            throw new IllegalArgumentException("Duplicate keys not allowed.");
        }
        this.view.insert(pair, n);
        this.updating = true;
        try {
            this.source.put(pair.key, pair.value);
        }
        finally {
            this.updating = false;
        }
        this.listListeners.itemInserted(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary.Pair<K, V> update(int n, Dictionary.Pair<K, V> pair) {
        if (pair == null) {
            throw new IllegalArgumentException("Pair is null.");
        }
        Dictionary.Pair<K, V> pair2 = this.view.get(n);
        if (!pair.key.equals(pair2.key) && this.source.containsKey(pair.key)) {
            throw new IllegalArgumentException("Duplicate keys not allowed.");
        }
        this.view.update(n, pair);
        this.updating = true;
        try {
            this.source.put(pair.key, pair.value);
        }
        finally {
            this.updating = false;
        }
        this.listListeners.itemUpdated(this, n, pair2);
        return pair2;
    }

    @Override
    public int remove(Dictionary.Pair<K, V> pair) {
        int n = this.indexOf(pair);
        if (n >= 0) {
            this.remove(n, 1);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence<Dictionary.Pair<K, V>> remove(int n, int n2) {
        Sequence<Dictionary.Pair<K, V>> sequence = this.view.remove(n, n2);
        this.updating = true;
        try {
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Dictionary.Pair<K, V> pair = sequence.get(i);
                this.source.remove(pair.key);
            }
        }
        finally {
            this.updating = false;
        }
        this.listListeners.itemsRemoved(this, n, sequence);
        return sequence;
    }

    @Override
    public Dictionary.Pair<K, V> get(int n) {
        return this.view.get(n);
    }

    @Override
    public int indexOf(Dictionary.Pair<K, V> pair) {
        return this.view.indexOf(pair);
    }

    private int linearSearch(Dictionary.Pair<K, V> pair) {
        int n = -1;
        int n2 = this.view.getLength();
        for (int i = 0; i < n2; ++i) {
            if (!this.view.get(i).equals(pair)) continue;
            n = i;
            break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.view.clear();
        this.updating = true;
        try {
            this.source.clear();
        }
        finally {
            this.updating = false;
        }
        this.listListeners.listCleared(this);
    }

    @Override
    public boolean isEmpty() {
        return this.view.isEmpty();
    }

    @Override
    public int getLength() {
        return this.view.getLength();
    }

    @Override
    public Comparator<Dictionary.Pair<K, V>> getComparator() {
        return this.view.getComparator();
    }

    @Override
    public void setComparator(Comparator<Dictionary.Pair<K, V>> comparator) {
        Comparator<Dictionary.Pair<K, V>> comparator2 = this.view.getComparator();
        this.view.setComparator(comparator);
        this.listListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<Dictionary.Pair<K, V>> iterator() {
        return this.view.iterator();
    }

    @Override
    public ListenerList<ListListener<Dictionary.Pair<K, V>>> getListListeners() {
        return this.listListeners;
    }

    public ListenerList<MapListListener<K, V>> getMapListListeners() {
        return this.mapListListeners;
    }

    private static class MapListListenerList<K, V>
    extends ListenerList<MapListListener<K, V>>
    implements MapListListener<K, V> {
        private MapListListenerList() {
        }

        @Override
        public void sourceChanged(MapList<K, V> mapList, Map<K, V> map) {
            for (MapListListener mapListListener : this) {
                mapListListener.sourceChanged(mapList, map);
            }
        }
    }
}

