/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ListenerList;

public interface Queue<T>
extends Collection<T> {
    public void enqueue(T var1);

    public T dequeue();

    public T peek();

    @Override
    public boolean isEmpty();

    public int getLength();

    public ListenerList<QueueListener<T>> getQueueListeners();

    public static class QueueListenerList<T>
    extends ListenerList<QueueListener<T>>
    implements QueueListener<T> {
        @Override
        public void itemEnqueued(Queue<T> queue, T t) {
            for (QueueListener queueListener : this) {
                queueListener.itemEnqueued(queue, t);
            }
        }

        @Override
        public void itemDequeued(Queue<T> queue, T t) {
            for (QueueListener queueListener : this) {
                queueListener.itemDequeued(queue, t);
            }
        }

        @Override
        public void queueCleared(Queue<T> queue) {
            for (QueueListener queueListener : this) {
                queueListener.queueCleared(queue);
            }
        }

        @Override
        public void comparatorChanged(Queue<T> queue, Comparator<T> comparator) {
            for (QueueListener queueListener : this) {
                queueListener.comparatorChanged(queue, comparator);
            }
        }
    }
}

