/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.ArrayStack;
import org.apache.pivot.util.ImmutableIterator;

public interface Sequence<T> {
    public int add(T var1);

    public void insert(T var1, int var2);

    public T update(int var1, T var2);

    public int remove(T var1);

    public Sequence<T> remove(int var1, int var2);

    public T get(int var1);

    public int indexOf(T var1);

    public int getLength();

    public static class Tree<T> {
        public static <T> int add(Sequence<T> sequence, T t, Path path) {
            return ((Sequence)Tree.get(sequence, path)).add(t);
        }

        public static <T> void insert(Sequence<T> sequence, T t, Path path, int n) {
            ((Sequence)Tree.get(sequence, path)).insert(t, n);
        }

        public static <T> T update(Sequence<T> sequence, Path path, T t) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            int n = 0;
            int n2 = path.getLength() - 1;
            while (n < n2) {
                sequence = (Sequence)sequence.get(path.get(n++));
            }
            return sequence.update(path.get(n), t);
        }

        public static <T> Path remove(Sequence<T> sequence, T t) {
            Path path = Tree.pathOf(sequence, t);
            if (path == null) {
                throw new IllegalArgumentException("item is not a descendant of sequence.");
            }
            Tree.remove(sequence, path, 1);
            return path;
        }

        public static <T> Sequence<T> remove(Sequence<T> sequence, Path path, int n) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            int n2 = 0;
            int n3 = path.getLength() - 1;
            while (n2 < n3) {
                sequence = (Sequence)sequence.get(path.get(n2++));
            }
            return sequence.remove(path.get(n2), n);
        }

        public static <T> T get(Sequence<T> sequence, Path path) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            int n = 0;
            int n2 = path.getLength() - 1;
            while (n < n2) {
                sequence = (Sequence)sequence.get(path.get(n++));
            }
            return sequence.get(path.get(n));
        }

        public static <T> Path pathOf(Sequence<T> sequence, T t) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (t == null) {
                throw new IllegalArgumentException("item is null.");
            }
            Path path = null;
            int n = sequence.getLength();
            for (int i = 0; i < n && path == null; ++i) {
                T t2 = sequence.get(i);
                if (t2.equals(t)) {
                    path = new Path();
                    path.add(i);
                    continue;
                }
                if (!(t2 instanceof Sequence) || (path = Tree.pathOf((Sequence)t2, t)) == null) continue;
                path.insert(i, 0);
            }
            return path;
        }

        public static <T> ItemIterator<T> depthFirstIterator(Sequence<T> sequence) {
            return new DepthFirstItemIterator<T>(sequence);
        }

        public static boolean isDescendant(Path path, Path path2) {
            int n;
            boolean bl;
            int n2 = path.getLength();
            boolean bl2 = bl = n2 <= (n = path2.getLength());
            if (bl) {
                int n3 = n2;
                for (int i = 0; i < n3; ++i) {
                    int n4;
                    int n5 = path.get(i);
                    if (n5 == (n4 = path2.get(i).intValue())) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }

        private static class DepthFirstItemIterator<T>
        implements ItemIterator<T> {
            private ArrayStack<Sequence<T>> stack = new ArrayStack();
            private Path previousPath = null;
            private Path nextPath = new Path();

            public DepthFirstItemIterator(Sequence<T> sequence) {
                this.stack.push(sequence);
                this.nextPath.add(0);
                this.normalize();
            }

            @Override
            public boolean hasNext() {
                return this.stack.peek() != null;
            }

            @Override
            public T next() {
                Sequence<T> sequence = this.stack.peek();
                if (sequence == null) {
                    throw new NoSuchElementException();
                }
                this.previousPath = new Path(this.nextPath);
                int n = this.nextPath.getLength();
                int n2 = this.nextPath.get(n - 1);
                T t = sequence.get(n2);
                if (t instanceof Sequence) {
                    this.stack.push((Sequence)t);
                    this.nextPath.add(0);
                } else {
                    this.nextPath.update(n - 1, n2 + 1);
                }
                this.normalize();
                return t;
            }

            private void normalize() {
                Sequence<T> sequence = this.stack.peek();
                int n = this.nextPath.getLength();
                int n2 = this.nextPath.get(n - 1);
                while (sequence != null && n2 >= sequence.getLength()) {
                    this.stack.pop();
                    sequence = this.stack.peek();
                    this.nextPath.remove(--n, 1);
                    if (n <= 0) continue;
                    n2 = this.nextPath.get(n - 1);
                    this.nextPath.update(n - 1, ++n2);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Path getPath() {
                if (this.previousPath == null) {
                    throw new IllegalStateException();
                }
                return this.previousPath;
            }
        }

        public static interface ItemIterator<T>
        extends Iterator<T> {
            public Path getPath();
        }

        public static class ImmutablePath
        extends Path {
            public ImmutablePath(Integer ... integerArray) {
                super(integerArray);
            }

            public ImmutablePath(Path path) {
                super(path);
            }

            @Override
            public int add(Integer n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void insert(Integer n, int n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Integer update(int n, Integer n2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Sequence<Integer> remove(int n, int n2) {
                throw new UnsupportedOperationException();
            }
        }

        public static class Path
        implements Sequence<Integer>,
        Iterable<Integer> {
            private ArrayList<Integer> elements;

            public Path() {
                this.elements = new ArrayList();
            }

            public Path(Integer ... integerArray) {
                this.elements = new ArrayList<Integer>(integerArray);
            }

            public Path(Path path) {
                this.elements = new ArrayList<Integer>(path.elements);
            }

            public Path(Path path, int n) {
                this.elements = new ArrayList<Integer>(path.elements, 0, n);
            }

            private Path(ArrayList<Integer> arrayList) {
                this.elements = arrayList;
            }

            @Override
            public int add(Integer n) {
                return this.elements.add(n);
            }

            @Override
            public void insert(Integer n, int n2) {
                this.elements.insert(n, n2);
            }

            @Override
            public Integer update(int n, Integer n2) {
                return this.elements.update(n, n2);
            }

            @Override
            public int remove(Integer n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Sequence<Integer> remove(int n, int n2) {
                return this.elements.remove(n, n2);
            }

            @Override
            public Integer get(int n) {
                return this.elements.get(n);
            }

            @Override
            public int indexOf(Integer n) {
                return this.elements.indexOf(n);
            }

            @Override
            public int getLength() {
                return this.elements.getLength();
            }

            @Override
            public Iterator<Integer> iterator() {
                return new ImmutableIterator<Integer>(this.elements.iterator());
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                int n = 0;
                for (Integer n2 : this.elements) {
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(n2);
                    ++n;
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }

            public Integer[] toArray() {
                return this.elements.toArray(Integer[].class);
            }

            public static Path forDepth(int n) {
                return new Path(new ArrayList<Integer>(n));
            }
        }
    }
}

