/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ListAdapter<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 1649736907064653706L;
    private java.util.List<T> list = null;
    private Comparator<T> comparator = null;
    private transient List.ListListenerList<T> listListeners = new List.ListListenerList();

    public ListAdapter(java.util.List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        }
        this.list = list;
    }

    public java.util.List<T> getList() {
        return this.list;
    }

    @Override
    public int add(T t) {
        int n = -1;
        if (this.comparator == null) {
            n = this.getLength();
        } else {
            n = Collections.binarySearch(this.list, t, this.comparator);
            if (n < 0) {
                n = -(n + 1);
            }
        }
        this.list.add(n, t);
        this.listListeners.itemInserted(this, n);
        return n;
    }

    @Override
    public void insert(T t, int n) {
        if (this.comparator != null && Collections.binarySearch(this.list, t, this.comparator) != -(n + 1)) {
            throw new IllegalArgumentException("Illegal insertion point.");
        }
        this.list.add(n, t);
        this.listListeners.itemInserted(this, n);
    }

    @Override
    public T update(int n, T t) {
        ListIterator<T> listIterator;
        Object t2;
        if (this.comparator != null) {
            t2 = null;
            listIterator = null;
            if (this.list instanceof RandomAccess) {
                if (n > 0) {
                    t2 = this.list.get(n - 1);
                }
                if (n < this.getLength() - 1) {
                    listIterator = this.list.get(n + 1);
                }
            } else if (n == 0) {
                listIterator = this.list.get(1);
            } else {
                ListIterator<T> listIterator2 = this.list.listIterator(n - 1);
                t2 = listIterator2.next();
                listIterator2.next();
                if (listIterator2.hasNext()) {
                    listIterator = listIterator2.next();
                }
            }
            if (t2 != null && this.comparator.compare(t, t2) == -1 || listIterator != null && this.comparator.compare((ListIterator<T>)t, listIterator) == 1) {
                throw new IllegalArgumentException("Illegal item modification.");
            }
        }
        if (this.list instanceof RandomAccess) {
            t2 = this.list.get(n);
            if (t2 != t) {
                this.list.set(n, t);
            }
            this.listListeners.itemUpdated(this, n, t2);
        } else {
            listIterator = this.list.listIterator(n);
            t2 = listIterator.next();
            if (t2 != t) {
                try {
                    listIterator.set(t);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.list.set(n, t);
                }
            }
            this.listListeners.itemUpdated(this, n, t2);
        }
        return t2;
    }

    @Override
    public int remove(T t) {
        int n = this.indexOf(t);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.remove(n, 1);
        return n;
    }

    @Override
    public Sequence<T> remove(int n, int n2) {
        java.util.List list = null;
        try {
            list = (java.util.List)this.list.getClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        ListAdapter<T> listAdapter = new ListAdapter<T>(list);
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                list.add(0, this.list.remove(n + i));
            }
            this.listListeners.itemsRemoved(this, n, listAdapter);
        }
        return listAdapter;
    }

    @Override
    public void clear() {
        if (this.getLength() > 0) {
            this.list.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public T get(int n) {
        return this.list.get(n);
    }

    @Override
    public int indexOf(T t) {
        return this.list.indexOf(t);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.comparator;
        if (comparator2 != comparator) {
            if (comparator != null) {
                Collections.sort(this.list, comparator);
            }
            this.comparator = comparator;
            this.listListeners.comparatorChanged(this, comparator2);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this.list.iterator());
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        return this.listListeners;
    }

    public String toString() {
        return this.list.toString();
    }
}

