/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class MapAdapter<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4005649560306864969L;
    private java.util.Map<K, V> map = null;
    private transient Map.MapListenerList<K, V> mapListeners = new Map.MapListenerList();

    public MapAdapter(java.util.Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public java.util.Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public V get(K k) {
        return this.map.get(k);
    }

    @Override
    public V put(K k, V v) {
        boolean bl = this.containsKey(k);
        V v2 = this.map.put(k, v);
        if (bl) {
            this.mapListeners.valueUpdated(this, k, v2);
        } else {
            this.mapListeners.valueAdded(this, k);
        }
        return v2;
    }

    @Override
    public V remove(K k) {
        Object v = null;
        if (this.containsKey(k)) {
            v = this.map.remove(k);
            this.mapListeners.valueRemoved(this, k, v);
        }
        return v;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.map.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int getCount() {
        return this.map.size();
    }

    @Override
    public Comparator<K> getComparator() {
        if (this.map instanceof SortedMap) {
            return ((SortedMap)this.map).comparator();
        }
        return null;
    }

    @Override
    public void setComparator(Comparator<K> comparator) {
        Comparator<K> comparator2 = this.getComparator();
        if (this.map instanceof SortedMap) {
            try {
                Constructor<?> constructor = this.map.getClass().getConstructor(Comparator.class);
                if (constructor != null) {
                    java.util.Map map = (java.util.Map)constructor.newInstance(comparator);
                    map.putAll(this.map);
                    this.map = map;
                }
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        this.mapListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<K> iterator() {
        return new ImmutableIterator<K>(this.map.keySet().iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        return this.mapListeners;
    }

    public String toString() {
        return this.map.toString();
    }
}

