/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedSet<E>
implements Set<E> {
    private Set<E> set;
    private SynchronizedSetListenerList<E> setListeners = new SynchronizedSetListenerList();

    public SynchronizedSet(Set<E> set) {
        if (set == null) {
            throw new IllegalArgumentException("set cannot be null.");
        }
        this.set = set;
    }

    @Override
    public synchronized boolean add(E e) {
        boolean bl = false;
        if (!this.contains(e)) {
            this.set.add(e);
            bl = true;
            this.setListeners.elementAdded(this, e);
        }
        return bl;
    }

    @Override
    public synchronized boolean remove(E e) {
        boolean bl = false;
        if (this.contains(e)) {
            this.set.remove(e);
            bl = true;
            this.setListeners.elementRemoved(this, e);
        }
        return bl;
    }

    @Override
    public synchronized boolean contains(E e) {
        return this.set.contains(e);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public synchronized void clear() {
        if (!this.set.isEmpty()) {
            this.set.clear();
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public synchronized int getCount() {
        return this.set.getCount();
    }

    @Override
    public synchronized Comparator<E> getComparator() {
        return this.set.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<E> comparator) {
        Comparator<E> comparator2 = this.getComparator();
        this.set.setComparator(comparator);
        this.setListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator(this.set.iterator());
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    private static class SynchronizedSetListenerList<E>
    extends Set.SetListenerList<E> {
        private SynchronizedSetListenerList() {
        }

        @Override
        public synchronized void add(SetListener<E> setListener) {
            super.add(setListener);
        }

        @Override
        public synchronized void remove(SetListener<E> setListener) {
            super.remove(setListener);
        }

        @Override
        public synchronized void elementAdded(Set<E> set, E e) {
            super.elementAdded(set, e);
        }

        @Override
        public synchronized void elementRemoved(Set<E> set, E e) {
            super.elementRemoved(set, e);
        }

        @Override
        public synchronized void setCleared(Set<E> set) {
            super.setCleared(set);
        }

        @Override
        public synchronized void comparatorChanged(Set<E> set, Comparator<E> comparator) {
            super.comparatorChanged(set, comparator);
        }
    }
}

