/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class ByteArraySerializer
implements Serializer<byte[]> {
    public static final String MIME_TYPE = "application/octet-stream";
    public static final int BUFFER_SIZE = 4096;

    @Override
    public byte[] readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        byte[] byArray = null;
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = bufferedInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return byArray;
    }

    @Override
    public void writeObject(byte[] byArray, OutputStream outputStream) throws IOException, SerializationException {
        if (byArray == null) {
            throw new IllegalArgumentException("byte array is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    @Override
    public String getMIMEType(byte[] byArray) {
        return MIME_TYPE;
    }
}

