/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class FileSizeFormat
extends Format {
    private static final long serialVersionUID = 9126510513247641698L;
    public static final int KILOBYTE = 1024;
    public static final String[] ABBREVIATIONS = new String[]{"K", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final FileSizeFormat FILE_SIZE_FORMAT = new FileSizeFormat();

    private FileSizeFormat() {
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Number number = (Number)object;
        long l = number.longValue();
        if (l >= 0L) {
            double d = l;
            int n = -1;
            do {
                ++n;
            } while ((d /= 1024.0) > 1024.0);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (n == 0 && d > 1.0) {
                numberFormat.setMaximumFractionDigits(0);
            } else {
                numberFormat.setMaximumFractionDigits(1);
            }
            stringBuffer.append(numberFormat.format(d) + " " + ABBREVIATIONS[n] + "B");
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public static FileSizeFormat getInstance() {
        return FILE_SIZE_FORMAT;
    }
}

