/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.ImmutableIterator;

public class MIMEType
implements Dictionary<String, String>,
Iterable<String> {
    private String baseType;
    private HashMap<String, String> parameters = new HashMap();

    public MIMEType(String string) {
        this.baseType = string;
    }

    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public String get(String string) {
        return this.parameters.get(string);
    }

    @Override
    public String put(String string, String string2) {
        return this.parameters.put(string, string2);
    }

    @Override
    public String remove(String string) {
        return this.parameters.remove(string);
    }

    @Override
    public boolean containsKey(String string) {
        return this.parameters.containsKey(string);
    }

    @Override
    public Iterator<String> iterator() {
        return new ImmutableIterator<String>(this.parameters.iterator());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.baseType);
        if (!this.parameters.isEmpty()) {
            for (String string : this.parameters) {
                stringBuilder.append("; " + string + "=" + this.parameters.get(string));
            }
        }
        return stringBuilder.toString();
    }

    public static MIMEType decode(String string) {
        MIMEType mIMEType;
        if (string == null) {
            throw new IllegalArgumentException("value is null.");
        }
        int n = string.indexOf(";");
        if (n == -1) {
            mIMEType = new MIMEType(string);
        } else {
            mIMEType = new MIMEType(string.substring(0, n));
            int n2 = string.length();
            do {
                String string2;
                int n3;
                if ((n3 = string.indexOf("=", n)) == -1) {
                    throw new IllegalArgumentException("Parameter list is invalid.");
                }
                String string3 = string.substring(n + 1, n3).trim();
                if (string3.length() == 0) {
                    throw new IllegalArgumentException("Missing parameter name.");
                }
                n = string.indexOf(";", n3);
                if (n == -1) {
                    n = n2;
                }
                if ((string2 = string.substring(n3 + 1, n).trim()).length() == 0) {
                    throw new IllegalArgumentException("Missing parameter value.");
                }
                mIMEType.put(string3, string2);
            } while (n < n2);
        }
        return mIMEType;
    }
}

