/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -3677773163272115116L;
    private byte majorRevision = 0;
    private byte minorRevision = 0;
    private byte maintenanceRevision = 0;
    private byte updateRevision = 0;
    private String build = null;

    public Version(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public Version(int n, int n2, int n3, int n4, String string) {
        if (n > 127) {
            throw new IllegalArgumentException("majorRevision must be less than 127.");
        }
        if (n2 > 255) {
            throw new IllegalArgumentException("minorRevision must be less than 255.");
        }
        if (n3 > 255) {
            throw new IllegalArgumentException("maintenanceRevision must be less than 255.");
        }
        if (n4 > 255) {
            throw new IllegalArgumentException("updateRevision must be less than 255.");
        }
        this.majorRevision = (byte)n;
        this.minorRevision = (byte)n2;
        this.maintenanceRevision = (byte)n3;
        this.updateRevision = (byte)n4;
        this.build = string;
    }

    public byte getMajorRevision() {
        return this.majorRevision;
    }

    public byte getMinorRevision() {
        return this.minorRevision;
    }

    public byte getMaintenanceRevision() {
        return this.maintenanceRevision;
    }

    public byte getUpdateRevision() {
        return this.updateRevision;
    }

    public int getNumber() {
        int n = (this.majorRevision & 0xFF) << 24 | (this.minorRevision & 0xFF) << 16 | (this.maintenanceRevision & 0xFF) << 8 | (this.updateRevision & 0xFF) << 0;
        return n;
    }

    @Override
    public int compareTo(Version version) {
        return this.getNumber() - version.getNumber();
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        return this.getNumber();
    }

    public String toString() {
        String string = this.majorRevision + "." + this.minorRevision + "." + this.maintenanceRevision + "_" + String.format("%02d", this.updateRevision);
        if (this.build != null) {
            string = string + "-" + this.build;
        }
        return string;
    }

    public static Version decode(String string) {
        String string2;
        Version version = null;
        byte by = 0;
        byte by2 = 0;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        int n3 = string.indexOf("-");
        if (n3 == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n3);
            string3 = string.substring(n3 + 1);
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray.length > 0) {
            by = Byte.parseByte(stringArray[0]);
            if (stringArray.length > 1) {
                String[] stringArray2;
                by2 = Byte.parseByte(stringArray[1]);
                if (stringArray.length > 2 && (stringArray2 = stringArray[2].split("_")).length > 0) {
                    n = Byte.parseByte(stringArray2[0]);
                    if (stringArray2.length > 1) {
                        n2 = Byte.parseByte(stringArray2[1]);
                    }
                }
            }
            version = new Version(by, by2, n, n2, string3);
        }
        return version;
    }
}

