/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import org.apache.pivot.collections.ArrayQueue;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.concurrent.SynchronizedQueue;

public class Dispatcher {
    private Queue<Runnable> pendingQueue = new SynchronizedQueue<Runnable>(new ArrayQueue());
    private Thread queueMonitorThread = null;

    public Dispatcher() {
        this(0, 10);
    }

    public Dispatcher(int n, int n2) {
    }

    public Queue<Runnable> getPendingQueue() {
        if (this.queueMonitorThread == null || !this.queueMonitorThread.isAlive()) {
            this.queueMonitorThread = new MonitorThread();
            this.queueMonitorThread.start();
        }
        return this.pendingQueue;
    }

    private class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(Dispatcher.this.getClass().getName() + "-MonitorThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = (Runnable)Dispatcher.this.pendingQueue.dequeue()) != null) {
                Thread thread = new Thread(runnable, Dispatcher.this.getClass().getName() + "-WorkerThread");
                thread.setPriority(1);
                thread.start();
            }
        }
    }
}

