/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;

public class TaskSequence
extends Task<Void>
implements Sequence<Task<?>>,
Iterable<Task<?>> {
    private ArrayList<Task<?>> tasks = new ArrayList();

    public TaskSequence() {
    }

    public TaskSequence(Dispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public Void execute() throws TaskExecutionException {
        for (Task task : this.tasks) {
            task.execute();
        }
        return null;
    }

    @Override
    public int add(Task<?> task) {
        int n = this.tasks.getLength();
        this.insert(task, n);
        return n;
    }

    @Override
    public void insert(Task<?> task, int n) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        this.tasks.insert(task, n);
    }

    @Override
    public Task<?> update(int n, Task<?> task) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.update(n, task);
    }

    @Override
    public int remove(Task<?> task) {
        int n = this.tasks.indexOf(task);
        if (n != -1) {
            this.tasks.remove(n, 1);
        }
        return n;
    }

    @Override
    public Sequence<Task<?>> remove(int n, int n2) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.remove(n, n2);
    }

    @Override
    public Task<?> get(int n) {
        return this.tasks.get(n);
    }

    @Override
    public int indexOf(Task<?> task) {
        return this.tasks.indexOf(task);
    }

    @Override
    public int getLength() {
        return this.tasks.getLength();
    }

    @Override
    public Iterator<Task<?>> iterator() {
        return new ImmutableIterator(this.tasks.iterator());
    }
}

