/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.xml.Element;
import org.apache.pivot.xml.Node;
import org.apache.pivot.xml.TextNode;

public class XMLSerializer
implements Serializer<Element> {
    private Charset charset = null;
    public static final String XMLNS_ATTRIBUTE_PREFIX = "xmlns";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String MIME_TYPE = "text/xml";
    public static final int BUFFER_SIZE = 2048;

    public XMLSerializer() {
        this(DEFAULT_CHARSET_NAME);
    }

    public XMLSerializer(String string) {
        this(string == null ? Charset.defaultCharset() : Charset.forName(string));
    }

    public XMLSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Element readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        Element element = this.readObject(bufferedReader);
        return element;
    }

    public Element readObject(Reader reader) throws SerializationException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        Element element = null;
        try {
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(reader);
            Node node = null;
            while (xMLStreamReader.hasNext()) {
                int n = xMLStreamReader.next();
                switch (n) {
                    case 4: {
                        if (xMLStreamReader.isWhiteSpace()) break;
                        String string3 = xMLStreamReader.getText();
                        ((Element)node).add(new TextNode(string3));
                        break;
                    }
                    case 1: {
                        String string;
                        String string2;
                        int n2;
                        String string3 = xMLStreamReader.getPrefix();
                        if (string3 != null && string3.length() == 0) {
                            string3 = null;
                        }
                        String string4 = xMLStreamReader.getLocalName();
                        Element element2 = new Element(string3, string4);
                        int n3 = xMLStreamReader.getNamespaceCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string2 = xMLStreamReader.getNamespacePrefix(n2);
                            string = xMLStreamReader.getNamespaceURI(n2);
                            if (string2 == null) {
                                element2.setDefaultNamespaceURI(string);
                                continue;
                            }
                            element2.getNamespaces().put(string2, string);
                        }
                        n3 = xMLStreamReader.getAttributeCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string2 = xMLStreamReader.getAttributePrefix(n2);
                            if (string2 != null && string2.length() == 0) {
                                string2 = null;
                            }
                            string = xMLStreamReader.getAttributeLocalName(n2);
                            String string5 = xMLStreamReader.getAttributeValue(n2);
                            element2.getAttributes().add(new Element.Attribute(string2, string, string5));
                        }
                        if (node == null) {
                            element = element2;
                        } else {
                            ((Element)node).add(element2);
                        }
                        node = element2;
                        break;
                    }
                    case 2: {
                        node = node.getParent();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException(xMLStreamException);
        }
        return element;
    }

    @Override
    public void writeObject(Element element, OutputStream outputStream) throws IOException, SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        this.writeObject(element, bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public void writeObject(Element element, Writer writer) throws SerializationException {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        if (element == null) {
            throw new IllegalArgumentException("element is null.");
        }
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(writer);
            xMLStreamWriter.writeStartDocument();
            this.writeElement(element, xMLStreamWriter);
            xMLStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException(xMLStreamException);
        }
    }

    private void writeElement(Element element, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, SerializationException {
        String string;
        String string2;
        String string3 = element.getNamespacePrefix();
        String string4 = element.getLocalName();
        if (string3 == null) {
            if (element.getLength() == 0) {
                xMLStreamWriter.writeEmptyElement(string4);
            } else {
                xMLStreamWriter.writeStartElement(string4);
            }
        } else {
            string2 = element.getNamespaceURI(string3);
            if (element.getLength() == 0) {
                xMLStreamWriter.writeEmptyElement(string3, string4, string2);
            } else {
                xMLStreamWriter.writeStartElement(string3, string4, string2);
            }
        }
        string2 = element.getDefaultNamespaceURI();
        if (string2 != null) {
            xMLStreamWriter.writeDefaultNamespace(string2);
        }
        Element.NamespaceDictionary namespaceDictionary = element.getNamespaces();
        for (Object object : namespaceDictionary) {
            string = namespaceDictionary.get((String)object);
            xMLStreamWriter.writeNamespace((String)object, string);
        }
        for (Object object : element.getAttributes()) {
            string = ((Element.Attribute)object).getNamespacePrefix();
            String string5 = ((Element.Attribute)object).getLocalName();
            String string6 = ((Element.Attribute)object).getValue();
            if (string == null) {
                xMLStreamWriter.writeAttribute(string5, string6);
                continue;
            }
            String string7 = element.getNamespaceURI(string);
            xMLStreamWriter.writeAttribute(string, string7, string5, string6);
        }
        for (Object object : element) {
            if (object instanceof Element) {
                this.writeElement((Element)object, xMLStreamWriter);
                continue;
            }
            if (object instanceof TextNode) {
                this.writeTextNode((TextNode)object, xMLStreamWriter);
                continue;
            }
            throw new SerializationException("Unsupported node type: " + object.getClass().getName());
        }
        if (element.getLength() > 0) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private void writeTextNode(TextNode textNode, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeCharacters(textNode.getText());
    }

    @Override
    public String getMIMEType(Element element) {
        return MIME_TYPE;
    }

    public static Element getElement(Element element, String string) {
        if (element == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(string.split("/"));
        Element element2 = element;
        int n = arrayList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            String string2;
            String string3 = arrayList.get(i);
            int n4 = string3.indexOf(91);
            if (n4 == -1) {
                string2 = string3;
                n3 = 0;
            } else {
                string2 = string3.substring(0, n4);
                n2 = string3.lastIndexOf(93);
                if (n2 == -1) {
                    throw new IllegalArgumentException("Unterminated index identifier.");
                }
                n3 = Integer.parseInt(string3.substring(n4 + 1, n2));
            }
            n2 = 0;
            int n5 = 0;
            for (Node node : element2) {
                Element element3;
                if (node instanceof Element && (element3 = (Element)node).getName().equals(string2)) {
                    if (n5 == n3) break;
                    ++n5;
                }
                ++n2;
            }
            if (n2 >= element2.getLength()) {
                element2 = null;
                break;
            }
            element2 = (Element)element2.get(n2);
        }
        return element2;
    }

    public static List<Element> getElements(Element element, String string, String string2) {
        Element element2 = XMLSerializer.getElement(element, string);
        return element2 == null ? null : element2.getElements(string2);
    }

    public static String getText(Element element, String string) {
        Element element2 = XMLSerializer.getElement(element, string);
        return element2 == null ? null : element2.getText();
    }
}

