package com.iptech.pivot;

import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;

import com.iptech.pivot.model.ContactModel;
import com.iptech.pivot.model.RemoteContactModel;
import com.iptech.pivot.ui.EditContactWindow;
import com.iptech.pivot.ui.TableContactsWindow;

public class Contacts implements Application,ContactAccessListener, ContactUpdateListener,ContactSubmitRequestListener {

	TableContactsWindow tcw;
	ContactModel model;
	
	public static void main(String[] args) {

		DesktopApplicationContext.main(Contacts.class, args);
	}

	@Override
	public void startup(Display display, Map<String, String> arg1)
	throws Exception {
		//Cre une fentre de table de contacts
		tcw = new TableContactsWindow(this);
		//Instancie le model
		model = new RemoteContactModel(this);
		//Demande au modle de rcuprer la liste des contacts
		model.retrieveAllContacts();
		//Affiche la fentre sur l'ecran principal
		tcw.getWindow().open(display);		
	}

	public void editContactRequest(Contact contact, TableContactsWindow source) {
		//Cre une fentre d'dition de contact
		EditContactWindow ecw = new EditContactWindow(this,source);
		//Met l'objet Contact cliqu pour dition
		ecw.setContact(contact);
		//Affiche la fentre
		ecw.show();
	}
	
	public void addContactRequest(TableContactsWindow source) {
		//Cre un nouvel objet Contact "vide"
		Contact newContact = new Contact(null, "", "", "", "");
		//Cre une fentre d'dition
		EditContactWindow ecw = new EditContactWindow(this,source);
		//Met le nouveau contact pour dition
		ecw.setContact(newContact);
		//Affiche la fentre d'dition
		ecw.show();
	}

	public void contactSubmit(Contact contact, EditContactWindow source) {
		model.saveContact(contact);
	}

	

	@Override
	public void contactsRetrieved(List<Contact> contacts) {
		tcw.setContacts(contacts);		
	}

	@Override
	public void contactSaved() {
		model.retrieveAllContacts();		
	}

	@Override
	public void resume() throws Exception {
		// TODO Auto-generated method stub
	
	}

	@Override
	public void suspend() throws Exception {
		// TODO Auto-generated method stub
	
	}

	@Override
	public boolean shutdown(boolean arg0) throws Exception {
		// TODO Auto-generated method stub
		return false;
	}


}
