package com.iptech.pivot.model;

import java.net.URL;

import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.web.GetQuery;
import org.apache.pivot.web.PostQuery;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactAccessListener;
import com.iptech.pivot.serializer.SerializerFactory;

public class RemoteContactModel implements ContactModel{

	private static final int PORT = 8080;
	private static final String HOST = "localhost";
	private static final String APP_NAME = "Contacts";
	private ContactAccessListener controller;

	public RemoteContactModel(ContactAccessListener controller) {
		super();
		this.controller = controller;
	}

	@Override
	public void retrieveAllContacts() {
		//Cre une requte GET
		GetQuery getQuery = new GetQuery(HOST,PORT, "/"+APP_NAME+"/Contact",false);
		//Affecte le serialiseur de contacts
		getQuery.setSerializer(SerializerFactory.getContactSerializer());
		//Lance la requte en affectant un couteur pour grer le retour de la rponse
		getQuery.execute(new TaskListener<Object>() {
			@SuppressWarnings("unchecked")
			@Override
			public void taskExecuted(Task<Object> task) {
				//task.getResult() = Rponse Objet dsrialis assum en tant que liste de contacts
				//On notifie le controller de la liste rcupre
				controller.contactsRetrieved(((org.apache.pivot.collections.List<Contact>)task.getResult()));
			}
			@Override
			public void executeFailed(Task<Object> task) {
				//Ne fait rien du tout si erreur
			}

		});
	}

	@Override
	public void saveContact(Contact contact) {
		//Cre une requte POST
		PostQuery post = new PostQuery(HOST,PORT, "/"+APP_NAME+"/Contact",false);
		//Affecte le serialiseur de contacts
		post.setSerializer(SerializerFactory.getContactSerializer());
		//Affecte l'objet Contact soumis (qui sera srialis)
		post.setValue(contact);
		//Lance la requte
		post.execute(new TaskListener<URL>() {

			@Override
			public void executeFailed(Task<URL> arg0) {
				//Ne fait rien du tout si erreur				
			}

			@Override
			public void taskExecuted(Task<URL> arg0) {
				//On notifie le controller que la requte s'est bien droule
				controller.contactSaved();				
			}
		});
		
		
	}

}
