package com.iptech.pivot.ui;

import java.io.IOException;

import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtkx.WTKXSerializer;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactSubmitRequestListener;

public class EditContactWindow {
	//Controleur
	private ContactSubmitRequestListener listener;
	//Tableau de contact associ
	private TableContactsWindow attachedTable;
	//Formulaire d'ajout/edition
	private Form form;
	//Fentre d'edition
	private Window editWindow;
	//Objet Contact en edition
	private Contact contact;


	public EditContactWindow(ContactSubmitRequestListener c,TableContactsWindow attachedTable) {
		super();
		this.listener = c;
		this.attachedTable = attachedTable;
		WTKXSerializer wtkxSerializer = new WTKXSerializer();
		try {
			editWindow = (Window)wtkxSerializer.readObject(this, "addContact.xml");
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SerializationException e) {
			e.printStackTrace();
		}
		
		form = (Form)wtkxSerializer.get("submitform");

		PushButton submit = (PushButton)wtkxSerializer.get("submitButton");
		submit.setAction(new Action() {
			@Override
			public void perform() {
				//Met  jour l'objet contact avec les valeurs des champs du formulaire
				//Apache Pivot se charge de faire l'association
				//entre les proprits de la classe Contact et les champs du formulaire
				form.store(contact);
				//Notifie le contrleur de la soumission du formulaire
				listener.contactSubmit(contact,EditContactWindow.this);
				//Ferme la fentre d'edition
				editWindow.close();
			}
		});
	}
	public void show(){
		editWindow.open(this.attachedTable.getWindow());
	}
	public void setAttachedTable(TableContactsWindow attachedTable) {
		this.attachedTable = attachedTable;
	}
	public TableContactsWindow getAttachedTable() {
		return attachedTable;
	}
	public Contact getContact() {
		return contact;
	}
	public void setContact(Contact contact) {
		this.contact = contact;
		//Les champs du formulaire se remplissent avec les infos du contact
		//Apache Pivot se charge de faire l'association
		//entre les proprits de la classe Contact et les champs du formulaire 
		form.load(contact);
	}

}
