package com.iptech.pivot.ui;

import java.io.IOException;

import org.apache.pivot.collections.List;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtkx.WTKXSerializer;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactUpdateListener;

public class TableContactsWindow {
	//Fentre
	private Window window = null;
	//Tableau des contacts
	private TableView table;
	//Contrleur
	private ContactUpdateListener controller;

	public TableContactsWindow(ContactUpdateListener c) {
		super();
		controller = c;
		WTKXSerializer wtkxSerializer = new WTKXSerializer();
		try {
			window = (Window)wtkxSerializer.readObject(this, "table.xml");
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SerializationException e) {
			e.printStackTrace();
		}
		table = (TableView)wtkxSerializer.get("tableView");
		//Ajoute un gestionnaire d'vnement pour le clic sur une ligne du tableau
		table.getComponentMouseButtonListeners().add(new ComponentMouseButtonListener.Adapter() {
			@SuppressWarnings("unchecked")
			@Override
			public boolean mouseClick(Component component,
					org.apache.pivot.wtk.Mouse.Button button, int x, int y, int count) {
				List<Contact> contacts = (List<Contact>)table.getTableData();
				//Rcupre l'indice de la ligne cliqu
				int index = table.getRowAt(y);
				//Notifie le contrleur de la demande d'dition d'un contact
				controller.editContactRequest(contacts.get(index),TableContactsWindow.this);
				return false;
			}
		});

		PushButton addButton  = (PushButton)wtkxSerializer.get("addButton");

		//Ajoute un gestionnaire d'vnement pour le clic sur le bouton 'Ajouter'
		addButton.getButtonPressListeners().add(new ButtonPressListener() {
			@Override
			public void buttonPressed(Button button) {
				//Notifie le contrleur du clic sur le bouton 'Ajouter'
				controller.addContactRequest(TableContactsWindow.this);
			}
		});
	}
	public void setContacts(List<Contact> result) {
		//Met  jour la table des contacts
		table.setTableData(result);
	}
	public Window getWindow() {
		return window;
	}
	public void setWindow(Window window) {
		this.window = window;
	}
	public TableView getTable() {
		return table;
	}

	public void setTable(TableView table) {
		this.table = table;
	}

}
