package com.iptech.pivot;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import javax.servlet.ServletException;

import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.web.QueryDictionary;
import org.apache.pivot.web.server.ClientException;
import org.apache.pivot.web.server.QueryServlet;

import com.iptech.pivot.dao.ContactDAO;
import com.iptech.pivot.dao.DAOFactory;
import com.iptech.pivot.serializer.SerializerFactory;

public class ContactCRUD extends QueryServlet {

	private static final long serialVersionUID = 1L;

	@Override
	protected Serializer<?> newSerializer() {
		//Retourner le serialiseur de contacts qui sera utilis pour srialiser/dsrialiser
		//les objets reus et retourns par les requtes HTTP
		return SerializerFactory.getContactSerializer();
	}

	protected Object doGet() throws ServletException, ClientException {

		//Rcupre le DAO
		ContactDAO dao = DAOFactory.getContactDao();
		//Cas o la requte porte sur tous les contacts
		List<Contact> all = dao.getAll();
		org.apache.pivot.collections.List<Contact> result = new org.apache.pivot.collections.ArrayList<Contact>();
		//Transforme une java.util.List en l'implmentation List de Pivot
		for(Contact c:all){
			result.add(c);				
		}
		//Retourne la liste
		//Apache Pivot se chargera par la suite de srialiser la liste
		//et de l'inclure dans une rponse HTTP
		return result;		
	}

	@Override
	protected URL doPost(Object value) throws ServletException, ClientException {
		//Apache Pivot s'est dj charg de dsrialiser l'objet envoy
		//dans la requte POST et nous l'a pass en paramtre
		Contact contact = (Contact)value;
		//Rcupre le DAO
		ContactDAO dao = DAOFactory.getContactDao();
		//Enregistre(ajoute ou met  jour) le contact envoy
		dao.save(contact);
		try {
			String app = this.getContextPath();
			return new URL("http://localhost:8080"+app+"/Contact");
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return null;
	}
}
