package com.iptech.pivot.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.iptech.pivot.Contact;
import com.iptech.pivot.dao.ContactDAO;

public class MemoryContactDAO implements ContactDAO {

	private static Map<Long, Contact> data = new HashMap<Long, Contact>();
	static Long lastId;
	
	static{
		data.put((long)1, new Contact((long)1,"Agatha", "Christie", "a.christie@iptech-offshore.com", "00000"));
		data.put((long)2, new Contact((long)2,"Conan", "Doyle", "c.doyle@iptech-offshore.com", "00000"));
		data.put((long)3, new Contact((long)3,"Charles", "Dickens", "c.dickens@iptech-offshore.com", "00000"));
		data.put((long)4, new Contact((long)4,"Franz", "Kafka", "f.kafka@iptech-offshore.com", "00000"));
		
		lastId = (long)4;
	}
	@Override
	public List<Contact> getAll() {
		List<Contact> contacts = new ArrayList<Contact>();
		for(Contact c:data.values()){
			contacts.add(c);
		}
		return contacts;
	}

	@Override
	public Contact getById(Long id) {		
		return data.get(id);
	}

	@Override
	public void save(Contact contact) {
		if(contact.getId() != null){
			data.put(contact.getId(), contact);
		}else{
			lastId ++;
			contact.setId(lastId);
			data.put(lastId, contact);			
		}

	}

}
