
// code projet boitelapincretin
// 3 mai 2015
// Programmez, Francois Tonic

// on déclare les librairies externes
#include "pitches.h"
#include <Adafruit_NeoPixel.h>

// buzzer en port 3
#define TonePIN  3

// neopixel en port 5
#define PIXEL_PIN    5    // Digital IO pin connected to the NeoPixels.
#define PIXEL_COUNT 16

// déclaration du velostat
const int velostatPin = 0;
int velostatValue = 0;

// on declare le capteur tilt et la led
const int tiltPin = 8;
const int ledPin =  2;

// variable du tilt
int tiltState = 0;

// déclare capteur ultrason et les variables de distance
int trig = 7;
int echo = 6;
long lecture_echo;
long cm;

// variables et melodie pour le buzzer
int thisNote;          // which note to play now
int noteDuration;      // How long to play the note
int pauseBetweenNotes; // Length between notes

int melody[] = {
  NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 0, NOTE_B3, NOTE_C4
};

// note durations: 4 = quarter note, 8 = eighth note, etc.:
int noteDurations[] = {
  4, 8, 8, 4, 4, 4, 4, 4
};

// les parametres du nneopixel
Adafruit_NeoPixel strip = Adafruit_NeoPixel(PIXEL_COUNT, PIXEL_PIN, NEO_GRB + NEO_KHZ800);

bool oldState = HIGH;
int showType = 0;

void setup()
{
  pinMode(trig, OUTPUT);
  digitalWrite(trig, LOW);
  pinMode(echo, INPUT);
  pinMode(ledPin, OUTPUT);
  pinMode(tiltPin, INPUT);

  pinMode(velostatPin, INPUT);
  strip.begin();
  strip.show(); // Initialize all pixels to 'off'
  colorWipe(strip.Color(0, 0, 0), 50);

  Serial.begin(9600);
}

void loop()
{

  velostatValue = analogRead(velostatPin);

  digitalWrite(trig, HIGH);
  delayMicroseconds(10);
  digitalWrite(trig, LOW);
  lecture_echo = pulseIn(echo, HIGH);
  cm = lecture_echo / 58;

  tiltState = digitalRead(tiltPin);

  Serial.print("Distancem : ");
  Serial.println(cm);
  Serial.println(tiltState);
  Serial.println(velostatValue);

  if (cm < 15)
  {
    digitalWrite(ledPin, HIGH);

  }
  else{
    digitalWrite(ledPin, LOW);
    
  }

  if (tiltState > 1) {

    for (thisNote = 0; thisNote < 8; thisNote++)
    { // Calculate and play one note and a pause after it

      // to calculate the note duration, take one second
      // divided by the note type.
      // e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
      noteDuration = 1000 / noteDurations[thisNote];
      tone(TonePIN, melody[thisNote], noteDuration);

      // to distinguish the notes, set a mæinimum time between them.
      // the note's duration + 30% seems to work well:
      pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
    }  // End of one note
  }

  else {

    digitalWrite(TonePIN, LOW);
  }

  if (velostatValue < 15) {
    theaterChase(strip.Color(  0,   0, 127), 50); // Blue
  }
  else if ((velostatValue > 16) and (velostatValue < 29)) {
    colorWipe(strip.Color(0, 255, 0), 50);
    
  }
  else {
    colorWipe(strip.Color(255, 0, 0), 50); // rouge
  }

}

// codes pour les différentes couleurs du neopixel
void colorWipe(uint32_t c, uint8_t wait) {
  for (uint16_t i = 0; i < strip.numPixels(); i++) {
    strip.setPixelColor(i, c);
    strip.show();
    delay(wait);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256; j++) {
    for (i = 0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256 * 5; j++) { // 5 cycles of all colors on wheel
    for (i = 0; i < strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

void theaterChase(uint32_t c, uint8_t wait) {
  for (int j = 0; j < 10; j++) { //do 10 cycles of chasing
    for (int q = 0; q < 3; q++) {
      for (int i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, c);  //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}

void theaterChaseRainbow(uint8_t wait) {
  for (int j = 0; j < 256; j++) {   // cycle all 256 colors in the wheel
    for (int q = 0; q < 3; q++) {
      for (int i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, Wheel( (i + j) % 255)); //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i = 0; i < strip.numPixels(); i = i + 3) {
        strip.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}

uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if (WheelPos < 85) {
    return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else if (WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  } else {
    WheelPos -= 170;
    return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  }
}


