#include <Wire.h>
#include "rgb_lcd.h"
#include <math.h>

#define LED 8


// capteur temperature TMP36 en A0
int tempMonitor = 0;

int outputpin = 1;

// declare bouton et variable etat bouton
int buttonState = 0;
const int buttonPin = 6;

// initialise écran LCD
rgb_lcd lcd;
const int colorR = 255;
const int colorG = 0;
const int colorB = 0;

// déclaration capteur d'alcool MQ3 en A0
const int analogPin = 3;

// initialise le tilt
const int tiltPin = 3;
int tiltState = 0;

unsigned char counter;
unsigned long temp[21];
unsigned long sub;
bool data_effect = true;
unsigned int heart_rate;//the measurement result of heart rate

const int max_heartpluse_duty = 2000;//you can change it follow your system's request.

void setup() {

  Serial.begin(9600);

  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  lcd.setRGB(colorR, colorG, colorB);

  pinMode(tiltPin, INPUT);

  pinMode(buttonPin, INPUT);

  pinMode(LED, OUTPUT);

  Serial.println("Please ready your chest belt.");
  delay(5000);
  arrayInit();
  Serial.println("Heart rate test begin.");
  attachInterrupt(0, interrupt, RISING);//set interrupt 0,digital port 2

}

void loop() {

  int sensorReading = analogRead(analogPin);

  buttonState = digitalRead(buttonPin);

  tiltState = digitalRead(tiltPin);

  Serial.println(sensorReading);

  Serial.println(buttonState);

  Serial.print("Tilt : ");
  Serial.print(tiltState);

  float temperature = getVoltage(tempMonitor);  //getting the voltage reading from the temperature sensor
  temperature = (temperature - .5) * 100;

  Serial.print(temperature);
  Serial.println(" Celsius");

  lcd.setCursor(0, 0);
  lcd.print("temp peau :");
  lcd.setCursor(12, 0);
  lcd.print(temperature);

  if (tiltState > 0) {
    digitalWrite(LED, HIGH);
  }
  else {
    digitalWrite(LED, LOW);

  }


  if (buttonState == HIGH) {
    if (sensorReading > 150) {
      lcd.setCursor(0, 1);
      lcd.print("Alcoolemie : oui");
      delay(1000);
      lcd.clear();

    }

    else if (sensorReading < 150) {
      lcd.setCursor(0, 1);
      lcd.print("Alcoolemie : non");
      delay(1000);
      lcd.clear();

    }
  }
  else {
    lcd.setCursor(0, 1);
    lcd.print("NB battement:");
    lcd.print(heart_rate);

  }

}

float getVoltage(int pin) {
  return (analogRead(pin) * .004882814); //converting from a 0 to 1024 digital range
  // to 0 to 5 volts (each 1 reading equals ~ 5 millivolts
}

void sum()
{
  if (data_effect)
  {
    heart_rate = 1200000 / (temp[20] - temp[0]); //60*20*1000/20_total_time
    Serial.print("Heart_rate_is:\t");
    Serial.println(heart_rate);



  }
  data_effect = 1; //sign bit

}
/*Function: Interrupt service routine.Get the sigal from the external interrupt*/
void interrupt()
{
  temp[counter] = millis();
  Serial.println(counter, DEC);
  Serial.println(temp[counter]);
  switch (counter)
  {
    case 0:
      sub = temp[counter] - temp[20];
      Serial.println(sub);
      break;
    default:
      sub = temp[counter] - temp[counter - 1];
      Serial.println(sub);
      break;
  }
  if (sub > max_heartpluse_duty) //set 2 seconds as max heart pluse duty
  {
    data_effect = 0; //sign bit
    counter = 0;
    Serial.println("Heart rate measure error,test will restart!" );
    arrayInit();
  }
  if (counter == 20 && data_effect)
  {
    counter = 0;
    sum();
  }
  else if (counter != 20 && data_effect)
    counter++;
  else
  {
    counter = 0;
    data_effect = 1;
  }

}
/*Function: Initialization for the array(temp)*/
void arrayInit()
{
  for (unsigned char i = 0; i < 20; i ++)
  {
    temp[i] = 0;
  }
  temp[20] = millis();
}



