// projet : tasse connectee pour geek vNext
// auteur : francois tonic / magazine programmez!
// code : françois tonic et morceaux de codes officiels et divers projets maker
// date : mai 2015

// librairies externes pour oled 96x96 sur I2C
#include <Wire.h>
#include <SeeedGrayOLED.h>

// receveur RF433 en A3, on met à zero la variable data RF433
#define rfReceivePin 0  //RF Receiver pin = Analog pin 0
int data = 0;


// librairie grove led bar
#include <Grove_LED_Bar.h>
Grove_LED_Bar bar(7, 6, 1);  // Clock pin, Data pin, Orientation

// initialise capteur de force en A0 / 0
// variable de lecteur du capteur
int fsrAnalogPin = 0;
int fsrReading;
int tasseok;

// capteur temperature TMP36 en A1
int sensorPin = 1;

// capteur humidite en A2
int mostureSensor = A2;

// on déclare la led verte en D3
const int ledPin = 3;

void setup() {
  Serial.begin(9600);

  // configuration du oled
  Wire.begin();
  SeeedGrayOled.init();
  SeeedGrayOled.clearDisplay(); // on nettoie tout
  SeeedGrayOled.setNormalDisplay();
  SeeedGrayOled.setVerticalMode();

  pinMode(ledPin, OUTPUT);
}

void loop() {
  // fsrReading lit la capteur de force
  fsrReading = analogRead(fsrAnalogPin);
  Serial.print("capteur de force:");
  Serial.println(fsrReading);
  tasseok = fsrReading;

  // lecture receveur RF433 et affichage sur moniteur série
  data = analogRead(rfReceivePin);

  bar.setBits(0x0);

  // lecteur et conversion capteur TMP36
  int reading = analogRead(sensorPin);
  float voltage = reading * 5.0;
  voltage /= 1024.0;
  float temperatureC = (voltage - 0.5) * 100 ;

  //on passe du float à un char pour afficher sur OLED
  char temp[10];
  String tempAsString;

  dtostrf(temperatureC, 1, 2, temp);
  tempAsString = String(temp);

  // initialise valeur capteur humidite en A2
  int sensorValue = analogRead(mostureSensor);

  // affichage des donnees sur le moniteur serie = humidite et tmp et RF433
  Serial.print("humidite :");
  Serial.println(sensorValue);
  Serial.print(temperatureC); Serial.println(" degrees C");
  Serial.print(data); Serial.println(" RF433");

  if (tasseok > 1000) {
    // oled : on definit la ligne, la colonne puis le contenu
    SeeedGrayOled.setTextXY(0, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(15); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse socle ");
    digitalWrite(ledPin, HIGH);
  }
  else {

    SeeedGrayOled.setTextXY(0, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(15); // 15 niveaux gris
    SeeedGrayOled.putString("Pas de tasse");
    digitalWrite(ledPin, LOW);

    bar.setBits(0x0);
  }

  if (temperatureC > 60) {
    bar.setBits(0b000001111111111);
    delay(3000);
  }
  else {
    bar.setBits(0b000000000011111);
    delay(3000);
  }

  SeeedGrayOled.setTextXY(5, 0); // ligne et colonne
  SeeedGrayOled.setGrayLevel(15); // 15 niveaux gris
  SeeedGrayOled.putString("TMP : ");
  SeeedGrayOled.setTextXY(5, 6); // ligne et colonne
  SeeedGrayOled.setGrayLevel(15); // 15 niveaux gris
  SeeedGrayOled.putString(temp);

  // si capteur A2 < 100 vide
  // si capteur A2 100 a 500 , un peu humide
  // si capteur A2 > 600, tasse pleine
  if (sensorValue >= 600)
  {
    SeeedGrayOled.setTextXY(3, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(10); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse pleine");
    SeeedGrayOled.setTextXY(4, 0);
    SeeedGrayOled.putString("      ");

    digitalWrite(ledPin, HIGH); // LED verte allumee
  }
  else if (sensorValue >= 100  && sensorValue < 600)
  {
    SeeedGrayOled.setTextXY(3, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(10); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse pas  ");
    SeeedGrayOled.setTextXY(4, 0);
    SeeedGrayOled.setGrayLevel(10);
    SeeedGrayOled.putString("pleine");

    digitalWrite(ledPin, HIGH); // LED verte allumee
    delay(100);
    digitalWrite(ledPin, LOW);
  }
  else if (sensorValue < 100)
  {
    SeeedGrayOled.setTextXY(3, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(10); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse vide  ");
    SeeedGrayOled.setTextXY(4, 0);
    SeeedGrayOled.putString("      ");

    digitalWrite(ledPin, LOW); // LED verte eteinte
  }

  if (data > 1022 ) {
    SeeedGrayOled.setTextXY(8, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(10); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse OK    ");
  }
  else {
    SeeedGrayOled.setTextXY(8, 0); // ligne et colonne
    SeeedGrayOled.setGrayLevel(10); // 15 niveaux gris
    SeeedGrayOled.putString("Tasse tombee");
  }

}
