﻿using BaZic.Core.ComponentModel;
using System.Runtime.CompilerServices;

namespace BaZic.Runtime.BaZic.Runtime.Interpreter.Expression
{
    /// <summary>
    /// Provides the bases of a expression interpreter.
    /// </summary>
    internal abstract class ExpressionInterpreter<T> where T : Code.AbstractSyntaxTree.Expression
    {
        #region Properties

        /// <summary>
        /// Gets the parent BaZic interpreter.
        /// </summary>
        protected BaZicInterpreterCore BaZicInterpreter { get; }

        /// <summary>
        /// Gets the parent interpreter.
        /// </summary>
        protected Interpreter ParentInterpreter { get; }

        /// <summary>
        /// Gets the expression to interpret.
        /// </summary>
        protected T Expression { get; }

        #endregion

        #region Constructors & Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ExpressionInterpreter"/> class.
        /// </summary>
        /// <param name="baZicInterpreter">The main interpreter.</param>
        /// <param name="parentInterpreter">The parent interpreter.</param>
        /// <param name="expression">The expression to interpret.</param>
        protected ExpressionInterpreter(BaZicInterpreterCore baZicInterpreter, Interpreter parentInterpreter, T expression)
        {
            Requires.NotNull(baZicInterpreter, nameof(baZicInterpreter));
            Requires.NotNull(parentInterpreter, nameof(parentInterpreter));
            Requires.NotNull(expression, nameof(expression));
            BaZicInterpreter = baZicInterpreter;
            ParentInterpreter = parentInterpreter;
            Expression = expression;
        }

        #endregion

        #region Methods

        /// <summary>
        /// Execute the interpretation of the expression.
        /// </summary>
        /// <returns>Returns the value generated by the expression.</returns>
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        internal abstract object Run();

        #endregion
    }
}
