#include <stdlib.h>
#include <stdio.h>
#include <SDL/SDL.h>
#include "cube.h"

void initopengl();
void initsdl();

int main(int argc, char* argv[])
{
  initsdl();
  initopengl();
  
  int x = 1;
  int y = 1;
  int z = 1;
  int quit = 0;

  while(!quit)
    {
      SDL_Event event;
      if(SDL_PollEvent(&event))
	{
	  switch(event.type)
	    {
	    case SDL_QUIT:
	      quit = 1;
	      break;
	    case SDL_KEYDOWN:
	      switch (event.key.keysym.sym)
		{
		case SDLK_UP:
		  x -= 1;
		  break;
		case SDLK_DOWN:
		  x += 1;
		  break;
		case SDLK_RIGHT:
		  z -= 1;
		  break;
		case SDLK_LEFT:
		  z += 1;
		  break;
		default:
		  break;
		}
	    default:
	      break;
	    }
	}
      
      draw_cube(x,y,z);
    }
  
  return 0;
}

void initopengl()
{
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glClearDepth(1.0);
  glEnable(GL_DEPTH_TEST);
  glViewport(0,0,640,480);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45.0, (float) 640/480, 1.0, 10.0);

}

void initsdl()
{
  SDL_Surface	*screen;

  if( SDL_Init( SDL_INIT_VIDEO ) == -1 )
    {
      printf( "Can't init SDL:  %s\n", SDL_GetError( ) );
      exit;
    }
  
  atexit( SDL_Quit ); 
  SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
  SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16);

  screen = SDL_SetVideoMode( 640, 480, 32, SDL_OPENGL
			     | SDL_GL_DOUBLEBUFFER
			     | SDL_RESIZABLE
			     | SDL_SWSURFACE);
  
  if( screen == NULL )
    {
      printf( "Can't set video mode: %s\n", SDL_GetError( ) );
      exit;
    }   
}
