import sys

class Token():
    add = 1
    sub = 2
    mul = 3
    div = 4
    mod = 5
    pal = 6
    par = 7
    number = 8

class Lexicon(dict):
    def key_list(self, keys, value):
        for key in keys:
            self[key] = value

class Stack(list):
    def push(self, item):
        self.append(item)
    def pop(self):
        return (self.pop())
    def is_empty(self):
        return (not self)

class Node():
    def __init__(self, data, left, right):
        self.right = left
        self.left = right
        self.data = data

def lexer(expr):
    lexicon = Lexicon({
        '+': Token.add,
        '-': Token.sub,
        '*': Token.mul,
        '/': Token.div,
        '%': Token.mod,
        '(': Token.pal,
        ')': Token.par
    })
    lexicon.key_list(
        ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'],
        Token.number)

    tokens = []
    datas = []

    for c in expr:
        if lexicon[c] == Token.number:
            if len(tokens) > 0 and tokens[-1] == Token.number:
                datas[-1] += c
            else:
                tokens.append(Token.number)
                datas.append(c);
        else:
            tokens.append(lexicon[c])
            datas.append(c)

    return (list(zip(tokens, datas)))

def priority(token):
    return (({ Token.add : 5,
       Token.sub : 5,
       Token.mul : 10,
       Token.div : 10,
       Token.mod : 10})[token])

def parser(tokens):
    stack = Stack()
    output = []

    for (token, data) in tokens:
        if token == Token.number:
            output.append(Node(data, None, None))
        elif token in [Token.add, Token.sub, Token.mul, Token.div, Token.mod]:
            for (op, op_str) in stack:
                if priority(token) < priority(op):
                    a = output.pop()
                    b = output.pop()
                    output.append(Node(op_str, a, b))

                    stack.pop()
                else:
                    break
            stack.insert(0, (token, data))

    for (op, op_str) in stack:
        a = output.pop()
        b = output.pop()

        output.append(Node(op_str, a, b))

    return (output.pop())

def eval(node):
    if node.data == '+':
        return (eval(node.left) + eval(node.right))
    elif node.data == '-':
        return (eval(node.left) - eval(node.right))
    elif node.data == '*':
        return (eval(node.left) * eval(node.right))
    elif node.data == '/':
        return (eval(node.left) / eval(node.right))
    elif node.data == '%':
        return (eval(node.left) % eval(node.right))
    else:
        return (int(node.data))

def main(argv):
    if len(sys.argv) == 2:
        print (eval(parser(lexer(sys.argv[1]))))
    else:
        print(sys.argv[0] + " expression")

if __name__ == "__main__":
    main(sys.argv)
