﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.WindowsMobile.PocketOutlook;

namespace SendContactsIRDA
{
    /// <summary>
    /// Class which describes a contact into the ListView.
    /// </summary>
    internal class ContactDesc
    {
        private PimItem _id;
        private string _detail;

        /// <summary>
        /// Gets or sets the identifier object associated to this contact.
        /// </summary>
        public PimItem Id
        {
            get
            {
                return _id;
            }
            set
            {
                _id = value;
            }
        }

        /// <summary>
        /// Gets or sets details of the contact.
        /// </summary>
        public string Detail
        {
            get
            {
                return _detail;
            }
            set
            {
                _detail = value;
            }
        }

        /// <summary>
        /// Constructor of the class.
        /// </summary>
        /// <param name="id">Identifier object to associate to this contact.</param>
        /// <param name="detail">Detail of the contact.</param>
        public ContactDesc(PimItem id, string detail)
        {
            Id = id;
            Detail = detail;
        }
    }
}
