﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using Microsoft.WindowsMobile.PocketOutlook;
using System.Reflection;
using System.IO;
using System.ComponentModel;
using System.Data;

namespace SendContactsIRDA
{
    /// <summary>
    /// Class which contains methods to serialize / deserialize xml document contacts.
    /// </summary>
    public class Utilities
    {
        private static OutlookSession _session;

        /// <summary>
        /// Gets or sets  current PocketOutlook session 
        /// </summary>
        public static OutlookSession Session
        {
            get
            {
                if (_session == null)
                {
                    _session = new OutlookSession();
                }
                return _session;
            }
            set
            {
                _session = value;
            }
        }

        /// <summary>
        /// Gets the number of contacts into PocketOutlook database
        /// </summary>
        static internal int ContactsCount
        {
            get
            {
                return Session.Contacts.Items.Count;
            }
        }

        /// <summary>
        /// Serialize contacts into an xml document.
        /// </summary>
        /// <param name="filename">Filename with full path.</param>
        /// <param name="contacts">List of contact to send.</param>
        static internal void CreateXmlDocument(string filename, List<ContactDesc> contacts)
        {
            FileStream fs = new FileStream(filename, FileMode.Create);

            ContactSet contactSet = new ContactSet();

            contacts.ForEach
                (
                    delegate (ContactDesc cd)
                    {
                        ContactSet.ContactRow contactRow = contactSet.Contact.NewContactRow();
                        
                        PropertyDescriptor descriptor = TypeDescriptor.GetProperties (typeof (Contact)).Find ("itemid", true);
                        int idx = Session.Contacts.Items.IndexOf (cd.Id);


                        PropertyInfo[] properties = Session.Contacts.Items[idx].GetType().GetProperties();

                        foreach (PropertyInfo pi in properties)
                        {
                            if (pi.CanRead && pi.CanWrite)
                            {
                                object ob = pi.GetValue(Session.Contacts.Items[idx], null);
                                if (ob != null)
                                {
                                    if (pi.PropertyType.FullName == typeof(DateTime).FullName)
                                    {
                                        DateTime dt = (DateTime)ob;
                                        contactRow[pi.Name] = dt.Ticks;
                                    }
                                    else if (pi.PropertyType.FullName == typeof(Uri).FullName)
                                    {
                                        Uri uri = (Uri)ob;
                                        contactRow[pi.Name] = uri.AbsoluteUri;
                                    }
                                    else
                                    {
                                        contactRow[pi.Name] = ob;
                                    }
                                }
                            }
                        }

                        contactSet.Contact.AddContactRow(contactRow);
                    }
                );
            contactSet.WriteXml (fs);
            fs.Close();
        }

        /// <summary>
        /// Deserialize an xml document which contains contacts.
        /// </summary>
        /// <param name="filename">Full pathname and filename of the xml document.</param>
        internal static void ComputeContacts(string filename)
        {
            Session.Dispose();
            Session = null;
            ContactSet cs = new ContactSet();
            cs.ReadXml(filename);

            foreach (ContactSet.ContactRow contactRow in cs.Contact)
            {
                Contact contact = Session.Contacts.Items.AddNew();
                PropertyInfo[] propertiesContact = contact.GetType().GetProperties();
                
                //int idx = 0;
                foreach (PropertyInfo pi in propertiesContact)
                {
                    if (pi.CanRead && pi.CanWrite && cs.Contact.Columns.Contains (pi.Name))
                    {
                        object ob = contactRow[pi.Name];
                        
                        if (ob != DBNull.Value)
                        {
                            if (pi.PropertyType.FullName == typeof(DateTime).FullName)
                            {
                                DateTime dt = new DateTime(long.Parse(ob.ToString()));
                                DateTime minValue = DateTime.MinValue;
                                if (dt != DateTime.MinValue && dt.Year != 1601)
                                {
                                    pi.SetValue(contact, dt, null);
                                }
                            }
                            else if (pi.PropertyType.FullName == typeof(Uri).FullName)
                            {
                                Uri uri = new Uri(ob.ToString());
                                pi.SetValue(contact, uri, null);                                 
                            }
                            else
                            {
                                pi.SetValue(contact, contactRow[pi.Name], null);
                            }
                        }
                    }
                }                
                contact.Update();                                
            }
            
        }
    }
}
