﻿using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Collections.Generic;
using Microsoft.WindowsMobile.PocketOutlook;

namespace SendContactsIRDA
{
    public partial class frmStart : System.Windows.Forms.Form
    {
        private System.Windows.Forms.MainMenu mainMenu1;
        private System.Windows.Forms.ListBox lstDevices;
        private System.Windows.Forms.StatusBar status;
        private System.Windows.Forms.Button btnSend;
        private System.Windows.Forms.Button btnReceive;
        private System.Windows.Forms.Button btnDiscover;

        private IrDAListener irListen;
        private IrDAClient irClient;
        private IrDAEndPoint irEndP;
        private IrDADeviceInfo[] irDevices;

        private string fileSend;
        private string fileReceive;
        private string irServiceName;

        private int buffersize;

        
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #region Windows Form Designer generated code
        private void InitializeComponent()
        {
            this.mainMenu1 = new System.Windows.Forms.MainMenu();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuItemRefresh = new System.Windows.Forms.MenuItem();
            this.menuItemQuit = new System.Windows.Forms.MenuItem();
            this.btnSend = new System.Windows.Forms.Button();
            this.lstDevices = new System.Windows.Forms.ListBox();
            this.btnReceive = new System.Windows.Forms.Button();
            this.status = new System.Windows.Forms.StatusBar();
            this.btnDiscover = new System.Windows.Forms.Button();
            this.lstContacts = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.progressBarContact = new System.Windows.Forms.ProgressBar();
            this.SuspendLayout();
            // 
            // mainMenu1
            // 
            this.mainMenu1.MenuItems.Add(this.menuItem1);
            // 
            // menuItem1
            // 
            this.menuItem1.MenuItems.Add(this.menuItemRefresh);
            this.menuItem1.MenuItems.Add(this.menuItemQuit);
            this.menuItem1.Text = "Menu";
            // 
            // menuItemRefresh
            // 
            this.menuItemRefresh.Text = "Refresh contact list";
            this.menuItemRefresh.Click += new System.EventHandler(this.menuItemRefresh_Click);
            // 
            // menuItemQuit
            // 
            this.menuItemQuit.Text = "Quit";
            this.menuItemQuit.Click += new System.EventHandler(this.menuItemQuit_Click);
            // 
            // btnSend
            // 
            this.btnSend.Location = new System.Drawing.Point(17, 220);
            this.btnSend.Name = "btnSend";
            this.btnSend.Size = new System.Drawing.Size(93, 20);
            this.btnSend.TabIndex = 4;
            this.btnSend.Text = "Send contacts";
            this.btnSend.Click += new System.EventHandler(this.Send_Click);
            // 
            // lstDevices
            // 
            this.lstDevices.Location = new System.Drawing.Point(17, 27);
            this.lstDevices.Name = "lstDevices";
            this.lstDevices.Size = new System.Drawing.Size(207, 44);
            this.lstDevices.TabIndex = 3;
            // 
            // btnReceive
            // 
            this.btnReceive.Location = new System.Drawing.Point(114, 220);
            this.btnReceive.Name = "btnReceive";
            this.btnReceive.Size = new System.Drawing.Size(110, 20);
            this.btnReceive.TabIndex = 2;
            this.btnReceive.Text = "Recieve contacts";
            this.btnReceive.Click += new System.EventHandler(this.Receive_Click);
            // 
            // status
            // 
            this.status.Location = new System.Drawing.Point(0, 246);
            this.status.Name = "status";
            this.status.Size = new System.Drawing.Size(240, 22);
            // 
            // btnDiscover
            // 
            this.btnDiscover.Location = new System.Drawing.Point(64, 5);
            this.btnDiscover.Name = "btnDiscover";
            this.btnDiscover.Size = new System.Drawing.Size(112, 20);
            this.btnDiscover.TabIndex = 0;
            this.btnDiscover.Text = "Discover Devices";
            this.btnDiscover.Click += new System.EventHandler(this.Discover_Click);
            // 
            // lstContacts
            // 
            this.lstContacts.CheckBoxes = true;
            this.lstContacts.Columns.Add(this.columnHeader1);
            this.lstContacts.FullRowSelect = true;
            this.lstContacts.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lstContacts.Location = new System.Drawing.Point(17, 77);
            this.lstContacts.Name = "lstContacts";
            this.lstContacts.Size = new System.Drawing.Size(207, 137);
            this.lstContacts.TabIndex = 5;
            this.lstContacts.View = System.Windows.Forms.View.List;
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Contact name";
            this.columnHeader1.Width = 193;
            // 
            // progressBarContact
            // 
            this.progressBarContact.Location = new System.Drawing.Point(3, 248);
            this.progressBarContact.Name = "progressBarContact";
            this.progressBarContact.Size = new System.Drawing.Size(237, 20);
            this.progressBarContact.Visible = false;
            // 
            // frmStart
            // 
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Inherit;
            this.ClientSize = new System.Drawing.Size(240, 268);
            this.Controls.Add(this.progressBarContact);
            this.Controls.Add(this.lstContacts);
            this.Controls.Add(this.btnDiscover);
            this.Controls.Add(this.status);
            this.Controls.Add(this.btnReceive);
            this.Controls.Add(this.lstDevices);
            this.Controls.Add(this.btnSend);
            this.Menu = this.mainMenu1;
            this.Name = "frmStart";
            this.Text = "SendContacts IRDA";
            this.Load += new System.EventHandler(this.frmStart_Load);
            this.ResumeLayout(false);

        }
        #endregion
       

        /// <summary>
        /// Handles the Discover devices button
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Discover_Click(object sender, System.EventArgs e)
        {
            // Create a collection of a maximum of three devices.
            irDevices = irClient.DiscoverDevices(2);

            // Show message if no devices are found.
            if (irDevices.Length == 0)
            {
                MessageBox.Show("No remote infrared devices found!");
                return;
            }

            // Enumerate the IrDADeviceInfo 
            // array and list device information  
            // for each device in the list box.
            string device;
            int ID;
            lstDevices.Items.Clear();
            foreach (IrDADeviceInfo irDevice in irDevices)
            {
                ID = BitConverter.ToInt32(irDevice.DeviceID, 0);
                device = ID.ToString() + " " + irDevice.DeviceName + " "
                    + irDevice.CharacterSet + " " + irDevice.Hints;
                lstDevices.Items.Add(device);
            }

            lstDevices.SelectedIndex = 0;
            if (irDevices.Length > 0)
                status.Text = irDevices.Length.ToString() + " remote device(s)";


            // Enable Send and Recieve buttons.
            btnSend.Enabled = true;
            btnReceive.Enabled = true;

        }


        /// <summary>
        /// Handles the Send button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Send_Click(object sender, System.EventArgs e)
        {
            List<ContactDesc> contacts = new List<ContactDesc>();
            
            foreach (ListViewItem item in lstContacts.Items)
            {
                if (item.Checked)
                {
                    contacts.Add(new ContactDesc((PimItem)item.Tag, item.Text));
                }
            }

            fileSend = Path.Combine(Path.GetTempPath(), "contacts.xml");
            Utilities.CreateXmlDocument(fileSend, contacts);

            //Open the file to send and get its stream.
            Stream fileStream;
            try
            {
                fileStream = new FileStream(fileSend, FileMode.Open);
            }
            catch (Exception exFile)
            {
                MessageBox.Show("Cannot open " + exFile.ToString());
                return;
            }

            //Create an IrDA client with a service name that must
            //match the service name of the receiving IrDA client.
            try
            {
                irClient = new IrDAClient(irServiceName);
            }
            catch (SocketException exS)
            {
                MessageBox.Show("Create socket error: " + exS.Message + " - Did you click Receive on the other device?");
                return;
            }

            // Get the underlying stream of the client.
            Stream baseStream = irClient.GetStream();

            //Get the size of the file to send 
            //and write its size to the stream.
            byte[] length = BitConverter.GetBytes((int)fileStream.Length);
            baseStream.Write(length, 0, length.Length);

            //Create buffer for reading the file.
            byte[] buffer = new byte[buffersize];

            // Display the number of bytes being sent.
            int fileLength = (int)fileStream.Length;
            status.Text = "Sending " + fileLength + " bytes";

            // Read the file stream into the base stream.
            while (fileLength > 0)
            {
                int numRead = fileStream.Read(buffer, 0, buffer.Length);
                baseStream.Write(buffer, 0, numRead);
                fileLength -= numRead;
            }

            fileStream.Close();
            baseStream.Close();
            irClient.Close();
            status.Text = "File sent";


        }
        /// <summary>
        /// Handles the Receive button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Receive_Click(object sender, System.EventArgs e)
        {
            fileReceive = Path.Combine(Path.GetTempPath(), "contacts.xml");

            //Create a stream for writing the file.
            Stream writeStream;
            try
            {
                writeStream = new FileStream(fileReceive,
                    FileMode.OpenOrCreate);
            }
            catch (Exception)
            {
                MessageBox.Show("Couldn't open "
                    + fileReceive + " for writing");
                return;
            }

            // Create a connection, with the IrDAEndPoint class, 
            // for the selected device in the list box. 
            // Start listening for incoming requests from  
            // that device with the IrDAListener class.
            try
            {
                int i = lstDevices.SelectedIndex;
                irEndP = new IrDAEndPoint(irDevices[i].DeviceID,
                    irServiceName);
                irListen = new IrDAListener(irEndP);
                irListen.Start();
            }
            catch (SocketException exSoc)
            {
                MessageBox.Show("Couldn't listen on service "
                    + irServiceName + ": "
                    + exSoc.ErrorCode);
            }

            // Show listening for selected device.
            status.Text = "Listening for "
                + lstDevices.SelectedItem.ToString();

            // Create a client connection for the 
            // service detected by the listener.
            IrDAClient irClient;
            try
            {
                irClient = irListen.AcceptIrDAClient();
            }
            catch (SocketException exp)
            {
                MessageBox.Show("Couldn't accept socket "
                    + exp.ErrorCode);
                return;
            }

            // Show whether a transfer from 
            // the remote device is pending.
            if (irListen.Pending() == true)
                status.Text = "Pending from "
                    + irClient.RemoteMachineName;
            else
                status.Text = "Not pending from "
                    + irClient.RemoteMachineName;

            // Get the underlying stream of the client.
            Stream baseStream = irClient.GetStream();

            int numToRead;

            //Create buffer for reading the file.
            byte[] buffer = new byte[buffersize];

            // Read the stream of data, which contains
            // the data from the remote device, until
            // there are no more bytes to read.
            numToRead = 4;
            while (numToRead > 0)
            {
                int numRead = baseStream.Read(buffer, 0, numToRead);
                numToRead -= numRead;
            }

            // Get the size of the buffer to show
            // the number of bytes to write to the file.
            numToRead = BitConverter.ToInt32(buffer, 0);
            status.Text = "Going to write "
                + numToRead + " bytes";

            // Write the stream to the file until
            // there are no more bytes to read.
            while (numToRead > 0)
            {
                int numRead = baseStream.Read(buffer, 0, buffer.Length);
                numToRead -= numRead;
                writeStream.Write(buffer, 0, numRead);
            }

            // Show file receive.
            status.Text = "File received";

            baseStream.Close();
            writeStream.Close();
            irListen.Stop();
            irClient.Close();

            Utilities.ComputeContacts(fileReceive);
        }

        private ListView lstContacts;
        private ColumnHeader columnHeader1;
        private MenuItem menuItem1;
        private MenuItem menuItemRefresh;
        private MenuItem menuItemQuit;
        private ProgressBar progressBarContact;
    }
}

