﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using Microsoft.WindowsMobile.PocketOutlook;

namespace SendContactsIRDA
{
    public partial class frmStart : Form
    {
        /// <summary>
        /// Initializes the form
        /// </summary>
        public frmStart()
        {
            InitializeComponent();

            irClient = new IrDAClient();

            // Specify a name for the IrDA Service.
            irServiceName = "IrDAFtp";

            // Set maximum buffer size for file transfers.
            buffersize = 256;

            // Display Pocket PC OK button for closing.
            this.MinimizeBox = false;

            getContacts();

            // Disable Send and Receive buttons until devices are discovered.
            btnSend.Enabled = false;
            btnReceive.Enabled = false;
        }

        private void frmStart_Load(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// Retrieves contacts from PocketOutlook database and inserts them into lstContacts ListView
        /// </summary>
        private void getContacts()
        {
            progressBarContact.Visible = true;
            progressBarContact.Maximum = Utilities.ContactsCount;
            progressBarContact.Value = 0;

            lstContacts.Clear();
            lstContacts.Refresh();

            List<ContactDesc> lstContactsToSend = new List<ContactDesc>();
            foreach (Contact contact in Utilities.Session.Contacts.Items)
            {
                string detail = contact.FirstName + " " + contact.LastName;
                
                ContactDesc cd = new ContactDesc((PimItem) contact, detail);
                lstContactsToSend.Add(cd);

                ListViewItem item = new ListViewItem(cd.Detail);
                item.Tag = contact;
                lstContacts.Items.Add(item);

                ++progressBarContact.Value;
            }
            progressBarContact.Visible = false;
            lstContacts.Refresh();
        }

        /// <summary>
        /// Handles Refresh item menu
        /// </summary>
        private void menuItemRefresh_Click(object sender, EventArgs e)
        {
            getContacts();
        }

        /// <summary>
        /// Handles Quit item menu
        /// </summary>
        private void menuItemQuit_Click(object sender, EventArgs e)
        {
            Utilities.Session.Contacts.Dispose();
            Application.Exit();
        }
    }
}