// ConsoleApplication.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

void Use_Lambda()
{
	vector<string> v;
	v.push_back("Edith");
	v.push_back("Lisa");
	v.push_back("Audrey Maggy");

	std::for_each(v.begin(), v.end(), [](string str) -> void {
		cout << str << endl;
	});
}

vector<string> Use_VectorReturn()
{
	vector<string> local_vector;
	local_vector.push_back("Edith");
	local_vector.push_back("Lisa");
	local_vector.push_back("Audrey Maggy");

	printf("local_vector=0x%08x\n", local_vector);
	return local_vector;
}

void Use_Initialisation()
{
	int i = {0};
	vector<int> v = { 10, 20, 30, 40, 50 };
	list<string> mes_filles = { "Edith", "Lisa", "Audrey Maggy" };
}

void Use_auto()
{
	auto i = 10;
	auto d = 1.275;
	auto s = "Maggy est une coquine !";
	
	vector<int> v = { 10, 20, 30, 40, 50 };
	for (auto it = v.begin(); it != v.end(); it++)
	{
		int v = *it;
		cout << "value = " << v << endl;
	}

	for (auto it = v.cbegin(); it != v.cend(); it++)
	{
		int v = *it;
		cout << "value = " << v << endl;
	}

	for (vector<int>::iterator it = v.begin(); it != v.end(); it++)
	{
		int v = *it;
		cout << "value = " << v << endl;
	}
}

void Use_RangeFor()
{
	vector<string> mes_filles = { "Edith", "Lisa", "Audrey" };
	for (string s : mes_filles )
	{
		cout << s << endl;
	}
}

class CPU
{
public:
	CPU() {}
	CPU(string name, string company) 
	{ 
		this->name = name; 
		this->company = company; 
	}
	CPU(string name, string company, double frequency) : CPU(name, company) 
	{ 
		this->frequency = frequency; 
	}
public:
	string name;
	string company;
	double frequency;
};

void Use_CtorDelegation()
{
	CPU cpu1("Pentium 4", "Intel");
	CPU cpu2("Core I3", "Intel", 3.1);
}

class Foo
{
public:
	Foo(char * p) { cout << "ctor char *" << endl; }
	Foo(int i) { cout << "ctor int" << endl;  }
};

void Use_NullPointer()
{
	CPU *ptr1 = NULL;
	CPU *ptr2 = nullptr;	// Modern C++
	Foo foo(nullptr);		// choose a ctor ???
}

void Use_RightAngleBracket()
{
	vector<vector<string> > vvs1;	// standard use with space
	vector<vector<string>> vvs2;		// OK with C++11
}

void Use_RawStringLiteral()
{
	string str1 = R"(\nhello\n)";
	cout << str1 << endl;
	string strXML1 = R"(<DataApollo>
  <Info>
    <PriceUnit>euro</PriceUnit>
    <VolumeUnit>TW0</VolumeUnit>
    <RunCode>2012-03_O0_avantEBO_V1_20130110</RunCode>
    <RunOption>am</RunOption>
    <GenerationDate>24-02-2014</GenerationDate>
    <CoreVersion>2.3.3.894</CoreVersion>
    <ReturnCode>0</ReturnCode>
  </Info>
</DataApollo>
)";
	cout << strXML1 << endl;
}

void Use_Tuple()
{
	tuple<string, string, int> maggy( "Maggy", "super coquine", 3);
	string str = get<1>(maggy);
	cout << str << endl;
}

void Use_SharedPtr()
{
	shared_ptr<CPU> cpuPtr = make_shared<CPU>();
	cpuPtr->company = "Intel";
}

class Bar final
{
};

#ifdef BAR
// Illegal construction !!!
class DerivedBar : public Bar
{
};
#endif

void Use_Array()
{
	array<int, 10> ar = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
	int a2 = ar[2];
	int a3 = ar.at(3);
}

void FnThread(vector<string> v)
{
	thread::id id = this_thread::get_id();
	cout << "Thread Id = " << id << endl;

	for (string s : v)
	{
		cout << s << endl;
	}
}

void Use_Thread()
{
	vector<string> mes_filles = { "Edith", "Lisa", "Audrey" };
	thread t(FnThread, mes_filles);
	t.join();
	cout << "Thread finished !" << endl;
}

int _tmain(int argc, _TCHAR* argv[])
{
	Use_Lambda();
	
	vector<string> v = Use_VectorReturn();
	printf("v=0x%08x\n", v);

	Use_Initialisation();
	Use_auto();
	Use_RangeFor();
	Use_CtorDelegation();
	Use_NullPointer();
	Use_RightAngleBracket();
	Use_RawStringLiteral();
	Use_Tuple();
	Use_SharedPtr();
	Use_Array();
	Use_Thread();
	return 0;
}


